/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.sdmx.map;

import java.text.ParseException;
import java.util.Calendar;
import org.cotrix.common.Report;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.common.Attribute;
import org.cotrix.domain.trait.Attributed;
import org.cotrix.domain.trait.Named;
import org.cotrix.io.impl.MapTask;
import org.cotrix.io.sdmx.SdmxElement;
import org.cotrix.io.sdmx.map.Codelist2SdmxDirectives;
import org.sdmxsource.sdmx.api.constants.TERTIARY_BOOL;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.mutable.base.AnnotationMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.ItemMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.NameableMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.codelist.CodelistMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.AnnotationMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.codelist.CodeMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.codelist.CodelistMutableBeanImpl;
import org.sdmxsource.sdmx.util.date.DateUtil;

public class Codelist2Sdmx
implements MapTask<Codelist, CodelistBean, Codelist2SdmxDirectives> {
    @Override
    public Class<Codelist2SdmxDirectives> directedBy() {
        return Codelist2SdmxDirectives.class;
    }

    @Override
    public CodelistBean map(Codelist codelist, Codelist2SdmxDirectives directives) throws Exception {
        double time = System.currentTimeMillis();
        Report.report().log("mapping codelist " + codelist.name() + "(" + codelist.id() + ") to SDMX");
        Report.report().log(Calendar.getInstance().getTime().toString());
        String name = directives.name() == null ? codelist.name().getLocalPart() : directives.name();
        CodelistMutableBeanImpl codelistbean = new CodelistMutableBeanImpl();
        codelistbean.setAgencyId(directives.agency());
        codelistbean.setId(name);
        codelistbean.setVersion(directives.version() == null ? codelist.version() : directives.version());
        codelistbean.setFinalStructure(directives.isFinal() == null ? TERTIARY_BOOL.UNSET : (directives.isFinal() == true ? TERTIARY_BOOL.TRUE : TERTIARY_BOOL.FALSE));
        this.mapCodelistAttributes(codelist, (CodelistMutableBean)codelistbean, directives);
        for (Code code : codelist.codes()) {
            CodeMutableBeanImpl codebean = new CodeMutableBeanImpl();
            codebean.setId(code.name().getLocalPart());
            this.mapAttributes(code, (NameableMutableBean)codebean, directives);
            codelistbean.addItem((ItemMutableBean)codebean);
        }
        Report.report().log("mapped codelist " + codelist.name() + "(" + codelist.id() + ") to SDMX in " + ((double)System.currentTimeMillis() - time) / 1000.0);
        return codelistbean.getImmutableInstance();
    }

    private void mapCodelistAttributes(Codelist list, CodelistMutableBean bean, Codelist2SdmxDirectives directives) {
        for (Attribute a : list.attributes()) {
            String val = a.value();
            SdmxElement element = directives.get(a);
            if (element == null) continue;
            switch (element) {
                case VALID_FROM: {
                    try {
                        bean.setStartDate(DateUtil.getDateTimeFormat().parse(val));
                    }
                    catch (ParseException e) {
                        Report.report().logWarning("unparseable start date: " + a.value());
                    }
                    break;
                }
                case VALID_TO: {
                    try {
                        bean.setEndDate(DateUtil.getDateTimeFormat().parse(val));
                        break;
                    }
                    catch (ParseException e) {
                        Report.report().logWarning("unparseable end date: " + a.value());
                    }
                }
            }
        }
        this.mapAttributes(list, (NameableMutableBean)bean, directives);
    }

    private <T extends Attributed & Named> void mapAttributes(T attributed, NameableMutableBean bean, Codelist2SdmxDirectives directives) {
        boolean hasName = false;
        for (Attribute a : attributed.attributes()) {
            String lang;
            String val = a.value();
            String string = lang = a.language() == null ? "en" : a.language();
            SdmxElement element = directives.get(a);
            if (element == null) continue;
            switch (element) {
                case NAME: {
                    bean.addName(lang, val);
                    hasName = true;
                    break;
                }
                case DESCRIPTION: {
                    bean.addDescription(lang, val);
                    break;
                }
                case ANNOTATION: {
                    AnnotationMutableBeanImpl annotation = new AnnotationMutableBeanImpl();
                    annotation.setTitle(a.name().getLocalPart());
                    annotation.addText(lang, val);
                    bean.addAnnotation((AnnotationMutableBean)annotation);
                }
            }
        }
        if (!hasName) {
            bean.addName("en", ((Named)attributed).name().getLocalPart());
        }
    }

    public String toString() {
        return "codelist-2-sdmx";
    }
}

