/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.impl;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.cotrix.common.Outcome;
import org.cotrix.common.Report;
import org.cotrix.common.Utils;
import org.cotrix.io.MapService;
import org.cotrix.io.impl.MapTask;
import org.cotrix.io.utils.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultMapService
implements MapService {
    private static Logger log = LoggerFactory.getLogger(DefaultMapService.class);
    private final Registry<MapTask<?, ?, ?>> registry;

    @Inject
    public DefaultMapService(Iterable<MapTask<?, ?, ?>> tasks) {
        Utils.notNull((String)"tasks", tasks);
        this.registry = new Registry(tasks);
        log.info("configured with tasks {}", this.registry.tasks());
    }

    @Override
    public <T, S> Outcome<S> map(T source, MapService.MapDirectives<S> directives) {
        Utils.notNull((String)"source", source);
        Utils.notNull((String)"directives", directives);
        double time = System.currentTimeMillis();
        try {
            MapTask<?, ?, ?> task = this.registry.get(directives);
            Object mapped = task.map(source, directives);
            time = ((double)System.currentTimeMillis() - time) / 1000.0;
            log.info("mapped source in {} secs.", (Object)time);
            Outcome outcome = new Outcome(mapped);
            return outcome;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not map source with directives " + directives + " (see cause) ", e);
        }
        finally {
            if (Report.report() != null) {
                Report.report().close();
            }
        }
    }
}

