/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.cotrix.domain.attributes.Definition;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.grammar.DefinitionGrammar;

public class SharedDefinitionPool
implements Iterable<Definition> {
    Map<DefinitionTemplate, Definition> defs = new HashMap<DefinitionTemplate, Definition>();

    public Definition get(String name, String type, String language) {
        return this.get(Codes.q((String)name), Codes.q((String)type), language);
    }

    public Definition get(QName name, QName type) {
        return this.get(name, type, null);
    }

    public Definition get(QName name, QName type, String language) {
        DefinitionTemplate key = this.key(name, type, language);
        Definition def = this.defs.get(key);
        if (def == null) {
            DefinitionGrammar.OptionalClause clause = (DefinitionGrammar.OptionalClause)Codes.definition().name(name);
            if (type != null) {
                clause.is(type);
            }
            if (language != null) {
                clause.in(language);
            }
            def = (Definition)clause.build();
            this.defs.put(key, def);
        }
        return def;
    }

    public Definition get(String name, String type) {
        return this.get(name, type, null);
    }

    @Override
    public Iterator<Definition> iterator() {
        return this.defs.values().iterator();
    }

    private DefinitionTemplate key(QName name, QName type, String language) {
        return new DefinitionTemplate(name, type, language);
    }

    private static class DefinitionTemplate {
        private final QName name;
        private final QName type;
        private final String language;

        DefinitionTemplate(QName name, QName type, String language) {
            this.name = name;
            this.type = type;
            this.language = language;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DefinitionTemplate other = (DefinitionTemplate)obj;
            if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

