/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.comet.map;

import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import org.cotrix.common.Log;
import org.cotrix.common.Report;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.common.NamedContainer;
import org.cotrix.domain.utils.Constants;
import org.cotrix.io.comet.map.Codelist2CometDirectives;
import org.cotrix.io.impl.MapTask;
import org.fao.fi.comet.mapping.dsl.DataProviderDSL;
import org.fao.fi.comet.mapping.dsl.MappingDSL;
import org.fao.fi.comet.mapping.dsl.MappingDataDSL;
import org.fao.fi.comet.mapping.dsl.MappingDetailDSL;
import org.fao.fi.comet.mapping.dsl.MappingElementDSL;
import org.fao.fi.comet.mapping.dsl.MappingElementIdentifierDSL;
import org.fao.fi.comet.mapping.model.DataProvider;
import org.fao.fi.comet.mapping.model.Mapping;
import org.fao.fi.comet.mapping.model.MappingData;
import org.fao.fi.comet.mapping.model.MappingDetail;
import org.fao.fi.comet.mapping.model.MappingElement;
import org.fao.fi.comet.mapping.model.MappingElementIdentifier;
import org.fao.fi.comet.mapping.model.MappingScoreType;
import org.fao.fi.comet.mapping.model.data.Property;
import org.fao.fi.comet.mapping.model.data.PropertyList;

public class Codelist2Comet
implements MapTask<Codelist, MappingData, Codelist2CometDirectives> {
    @Override
    public Class<Codelist2CometDirectives> directedBy() {
        return Codelist2CometDirectives.class;
    }

    @Override
    public MappingData map(Codelist codelist, Codelist2CometDirectives directives) throws Exception {
        double time = System.currentTimeMillis();
        Report.report().log((Report.Item)Log.item((String)("mapping codelist " + codelist.name() + "(" + codelist.id() + ") to Comet"))).as(Report.Item.Type.INFO).log((Report.Item)Log.item((String)Calendar.getInstance().getTime().toString())).as(Report.Item.Type.INFO);
        NamedContainer attributes = codelist.attributes();
        DataProvider source = DataProviderDSL.provider((String)"http://cotrix.org", (String)"http://cotrix.org/codelist", (String)("http://cotrix.org/codelist/" + this.encode(codelist.name().toString())), (String)codelist.version());
        String previous = attributes.contains(Constants.PREVIOUS_VERSION) ? ((Attribute)attributes.lookup(Constants.PREVIOUS_VERSION)).value() : null;
        DataProvider target = DataProviderDSL.provider((String)"http://cotrix.org", (String)"http://cotrix.org/codelist", (String)("http://cotrix.org/codelist/" + this.encode(codelist.name().toString())), (String)previous);
        MappingData data = new MappingData().id(this.uri(codelist.name() + ":" + codelist.version() + (previous == null ? "" : ":" + previous))).version(codelist.version()).producedBy("http://cotrix.org").linking(source).to(target).on(new Date()).with(MappingDataDSL.minimumWeightedScore((double)1.0), MappingDataDSL.maximumCandidates((int)1));
        if (previous != null) {
            data.setDescription(String.format("A mapping between codelist v.%s and v.%s of codelist %s", codelist.version(), previous, codelist.name()));
        }
        for (Code c : codelist.codes()) {
            try {
                attributes = c.attributes();
                MappingElement element = MappingElementDSL.wrap((Object)this.properties((NamedContainer<? extends Attribute>)attributes)).with(this.id(c.name()));
                Mapping mapping = MappingDSL.map((MappingElement)element);
                List<MappingDetail> targets = this.targets((NamedContainer<? extends Attribute>)attributes, directives);
                if (!targets.isEmpty()) {
                    mapping.to(targets.toArray(new MappingDetail[0]));
                }
                data.including(mapping);
            }
            catch (Exception e) {
                Report.report().log((Report.Item)Log.item((String)String.format("code %s cannot be mapped (%s)", c.name(), e.getMessage()))).as(Report.Item.Type.ERROR);
            }
        }
        String msg = String.format("transformed codelist %s (%s) to Comet in %s", codelist.name(), codelist.id(), ((double)System.currentTimeMillis() - time) / 1000.0);
        Report.report().log((Report.Item)Log.item((String)msg)).as(Report.Item.Type.INFO);
        return data;
    }

    private List<MappingDetail> targets(NamedContainer<? extends Attribute> attrs, Codelist2CometDirectives directives) {
        ArrayList<MappingDetail> targets = new ArrayList<MappingDetail>();
        for (QName name : directives.targetAttributes()) {
            for (Attribute attr : attrs.getAll(name)) {
                try {
                    targets.add(MappingDetailDSL.target((MappingElement)MappingElementDSL.wrap((Object)this.targetProperties(attr)).with(this.id(attr.value()))).withMappingScore(1.0, MappingScoreType.AUTHORITATIVE));
                }
                catch (Exception e) {
                    Report.report().log((Report.Item)Log.item((String)String.format("{} attribute cannot be mapped to target identifier", name))).as(Report.Item.Type.ERROR);
                }
            }
        }
        return targets;
    }

    private MappingElementIdentifier id(QName name) throws Exception {
        return this.id(name.getLocalPart());
    }

    private MappingElementIdentifier id(String id) throws Exception {
        return MappingElementIdentifierDSL.identifierFor((URI)this.uri(id));
    }

    private URI uri(String id) throws Exception {
        return new URI(this.encode(id));
    }

    private String encode(String id) throws Exception {
        return URLEncoder.encode(id, "UTF-8");
    }

    private PropertyList properties(NamedContainer<? extends Attribute> attributes) {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Attribute a : attributes) {
            if (a.is(Constants.SYSTEM_TYPE)) continue;
            properties.add(this.propertyOf(a));
        }
        return new PropertyList(properties);
    }

    private PropertyList targetProperties(Attribute ... attributes) {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Attribute a : attributes) {
            properties.add(new Property(a.name().toString(), a.type().toString(), a.description()));
        }
        return new PropertyList(properties);
    }

    private Property propertyOf(Attribute a) {
        return new Property(a.name().toString(), a.type().toString(), a.value());
    }

    public String toString() {
        return "codelist-2-comet";
    }
}

