/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.tabular.map;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.cotrix.common.Report;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.links.Link;
import org.cotrix.domain.trait.Defined;
import org.cotrix.domain.trait.Identified;
import org.cotrix.io.impl.MapTask;
import org.cotrix.io.tabular.map.Codelist2TableDirectives;
import org.cotrix.io.tabular.map.MemberDirective;
import org.virtualrepository.tabular.Column;
import org.virtualrepository.tabular.DefaultTable;
import org.virtualrepository.tabular.Row;
import org.virtualrepository.tabular.Table;

public class Codelist2Table
implements MapTask<Codelist, Table, Codelist2TableDirectives> {
    public static final String DEFAULT_CODECOLUMN = "code";

    @Override
    public Class<Codelist2TableDirectives> directedBy() {
        return Codelist2TableDirectives.class;
    }

    @Override
    public Table map(Codelist list, Codelist2TableDirectives directives) throws Exception {
        double time = System.currentTimeMillis();
        Report.report().log("transforming codelist " + list.qname() + "(" + list.id() + ") to table");
        Report.report().log(Calendar.getInstance().getTime().toString());
        ArrayList<Column> columns = new ArrayList<Column>();
        QName codeColumnName = directives.codeColumnName() == null ? new QName(DEFAULT_CODECOLUMN) : directives.codeColumnName();
        columns.add(new Column(codeColumnName));
        for (MemberDirective<?> directive : directives.members()) {
            columns.add(new Column(directive.column()));
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        for (Code code : list.codes()) {
            MemberDirective<?> d;
            HashMap<QName, String> values = new HashMap<QName, String>();
            HashMap<QName, Attribute> attributeMatches = new HashMap<QName, Attribute>();
            HashMap<QName, Link> linkMatches = new HashMap<QName, Link>();
            values.put(codeColumnName, code.qname().getLocalPart());
            for (Attribute a : code.attributes()) {
                d = directives.member((Defined<?>)a);
                if (d == null) continue;
                attributeMatches.put(d.column(), a);
            }
            for (Link l : code.links()) {
                d = directives.member((Defined<?>)l);
                if (!this.matches(d, (Defined<? extends Identified>)l)) continue;
                linkMatches.put(d.column(), l);
            }
            for (Column col : columns) {
                String error = "transformation is ambiguous: code " + code.qname() + " has multiple attributes that map onto column " + col.name();
                boolean matchesAttributes = attributeMatches.containsKey(col.name());
                boolean matchesLinks = linkMatches.containsKey(col.name());
                if (!matchesAttributes && !matchesLinks) continue;
                if (values.containsKey(col.name())) {
                    switch (directives.mode()) {
                        case strict: {
                            throw new IllegalStateException(error);
                        }
                        case log: {
                            Report.report().log(error).as(Report.Item.Type.WARN);
                        }
                    }
                }
                String val = matchesAttributes ? ((Attribute)attributeMatches.get(col.name())).value() : ((Link)linkMatches.get(col.name())).valueAsString();
                values.put(col.name(), val);
            }
            rows.add(new Row(values));
        }
        Report.report().log("transformed codelist " + list.qname() + "(" + list.id() + ") to table in " + ((double)System.currentTimeMillis() - time) / 1000.0);
        return new DefaultTable(columns, rows);
    }

    private boolean matches(MemberDirective<?> directive, Defined<? extends Identified> member) {
        return directive == null ? false : directive.definition().id().equals(member.definition().id());
    }
}

