/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.tabular.map;

import org.cotrix.common.Report;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.dsl.Data;
import org.cotrix.io.tabular.map.ColumnDirectives;
import org.cotrix.io.utils.SharedDefinitionPool;
import org.virtualrepository.tabular.Row;

public class Column2Attribute {
    private final ColumnDirectives mapping;

    public Column2Attribute(ColumnDirectives mapping) {
        this.mapping = mapping;
    }

    public Attribute map(String codename, Row row, SharedDefinitionPool defs) {
        String value = row.get(this.mapping.column());
        if (!this.valid(codename, value)) {
            return null;
        }
        AttributeDefinition def = defs.get(this.mapping.name(), this.mapping.type(), this.mapping.language());
        return (Attribute)Data.attribute().instanceOf(def).value(value).build();
    }

    private boolean valid(String codename, String value) {
        if (value == null || value.isEmpty()) {
            if (this.mapping.required()) {
                String msg = "code " + codename + " has no value for attribute '" + this.mapping.name() + "'";
                switch (this.mapping.mode()) {
                    case strict: {
                        Report.report().log(msg).as(Report.Item.Type.ERROR);
                        break;
                    }
                    case log: {
                        Report.report().log(msg).as(Report.Item.Type.WARN);
                        break;
                    }
                }
            }
            return false;
        }
        return true;
    }
}

