/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.lifecycle.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.cotrix.common.Utils;
import org.cotrix.lifecycle.Lifecycle;
import org.cotrix.lifecycle.LifecycleEvent;
import org.cotrix.lifecycle.LifecycleFactory;
import org.cotrix.lifecycle.LifecycleRegistry;
import org.cotrix.lifecycle.LifecycleService;
import org.cotrix.lifecycle.State;
import org.cotrix.lifecycle.impl.LifecycleRepository;

public class DefaultLifecycleService
implements LifecycleService {
    @Inject
    @Any
    private Event<LifecycleEvent> event;
    @Inject
    private LifecycleRegistry registry;
    @Inject
    private LifecycleRepository repository;

    @Override
    public Lifecycle start(String id) {
        return this.start(id, (State)null);
    }

    @Override
    public Lifecycle start(String id, State startState) {
        return this.start("__default__", id, startState);
    }

    @Override
    public Lifecycle start(String name, String id) {
        return this.start(name, id, null);
    }

    @Override
    public Lifecycle start(String name, String id, State state) {
        Utils.valid((String)"lifecycle name", (String)name);
        Utils.valid((String)"resource identifier", (String)id);
        LifecycleFactory factory = this.registry.get(name);
        if (factory == null) {
            throw new IllegalStateException("factory " + name + " is unknown");
        }
        Lifecycle lc = state == null ? factory.create(id) : factory.create(id, state);
        this.repository.add(lc);
        lc.setEventProducer(this.event);
        return lc;
    }

    @Override
    public Lifecycle lifecycleOf(String id) {
        Utils.valid((String)"resource identifier", (String)id);
        LifecycleRepository.ResumptionToken token = this.repository.lookup(id);
        if (token == null) {
            throw new IllegalStateException("no known lifecycle for resource " + id);
        }
        LifecycleFactory factory = this.registry.get(token.name);
        Lifecycle lc = factory.create(id, token.state);
        lc.setEventProducer(this.event);
        return lc;
    }

    @Override
    public Map<String, Lifecycle> lifecyclesOf(Collection<String> ids) {
        Utils.notNull((String)"resource identifiers", ids);
        HashMap<String, Lifecycle> lifecycles = new HashMap<String, Lifecycle>();
        if (ids.isEmpty()) {
            return lifecycles;
        }
        for (Map.Entry<String, LifecycleRepository.ResumptionToken> tokenEntry : this.repository.lookup(ids).entrySet()) {
            LifecycleRepository.ResumptionToken token = tokenEntry.getValue();
            LifecycleFactory factory = this.registry.get(token.name);
            Lifecycle lc = factory.create(tokenEntry.getKey(), token.state);
            lc.setEventProducer(this.event);
            lifecycles.put(lc.resourceId(), lc);
        }
        return lifecycles;
    }

    @Override
    public void update(Lifecycle lc) {
        Utils.notNull((String)"lifecycle", (Object)lc);
        this.repository.update(lc);
    }

    @Override
    public void delete(String id) {
        Utils.notNull((String)"resource identifier", (Object)id);
        this.repository.delete(id);
    }
}

