/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo;

import javax.enterprise.event.Observes;
import org.cotrix.common.cdi.ApplicationEvents;
import org.cotrix.neo.domain.Constants;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;

public class NeoNodeFactory {
    private static GraphDatabaseService store;

    static void startup(@Observes ApplicationEvents.Startup event, GraphDatabaseService store) {
        NeoNodeFactory.store = store;
    }

    public static Node newnode(Constants.NodeType type) {
        return store.createNode(new Label[]{type});
    }

    public static Node node(Constants.NodeType type, String id) {
        Node node = NeoNodeFactory.nodeFor(type, id);
        return node == null ? null : node;
    }

    private static Node nodeFor(Constants.NodeType type, String id) {
        try (ResourceIterator retrieved = store.findNodesByLabelAndProperty((Label)type, "id", (Object)id).iterator();){
            Node node = retrieved.hasNext() ? (Node)retrieved.next() : null;
            return node;
        }
    }
}

