/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.domain;

import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.codelist.CodelistLink;
import org.cotrix.domain.common.Range;
import org.cotrix.domain.common.Ranges;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.links.LinkOfLink;
import org.cotrix.domain.links.LinkValueType;
import org.cotrix.domain.links.NameLink;
import org.cotrix.domain.trait.Named;
import org.cotrix.domain.values.ValueFunction;
import org.cotrix.domain.values.ValueFunctions;
import org.cotrix.neo.NeoUtils;
import org.cotrix.neo.domain.Constants;
import org.cotrix.neo.domain.NeoCodelist;
import org.cotrix.neo.domain.NeoNamed;
import org.cotrix.neo.domain.utils.NeoStateFactory;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class NeoCodelistLink
extends NeoNamed
implements CodelistLink.State {
    public static final NeoStateFactory<CodelistLink.State> factory = new NeoStateFactory<CodelistLink.State>(){

        @Override
        public CodelistLink.State beanFrom(Node node) {
            return new NeoCodelistLink(node);
        }

        @Override
        public Node nodeFrom(CodelistLink.State state) {
            return new NeoCodelistLink(state).node();
        }
    };

    public NeoCodelistLink(Node node) {
        super(node);
    }

    public NeoCodelistLink(CodelistLink.State state) {
        super(Constants.NodeType.CODELISTLINK, state);
        this.target(state.target());
        this.valueType(state.valueType());
        this.function(state.function());
        this.range(state.range());
    }

    public CodelistLink.Private entity() {
        return new CodelistLink.Private((CodelistLink.State)this);
    }

    public Codelist.State target() {
        Relationship rel = this.node().getSingleRelationship((RelationshipType)Constants.Relations.LINK, Direction.OUTGOING);
        if (rel == null) {
            throw new IllegalStateException("orphaned codelist link " + this.name() + " (" + this.id() + ")");
        }
        return (Codelist.State)NeoCodelist.factory.beanFrom(rel.getEndNode());
    }

    public void target(Codelist.State state) {
        Node target = this.resolve((Named.State)state, Constants.NodeType.CODELIST);
        if (target != null) {
            this.node().createRelationshipTo(target, (RelationshipType)Constants.Relations.LINK);
        }
    }

    public LinkValueType valueType() {
        if (this.node().hasProperty("type")) {
            return (LinkValueType)NeoUtils.binder().fromXML((String)this.node().getProperty("type"));
        }
        Relationship rel = this.node().getSingleRelationship((RelationshipType)Constants.Relations.LOL, Direction.OUTGOING);
        if (rel != null) {
            return new LinkOfLink((CodelistLink)((CodelistLink.State)factory.beanFrom(rel.getEndNode())).entity());
        }
        return NameLink.INSTANCE;
    }

    public void valueType(LinkValueType state) {
        if (state == NameLink.INSTANCE) {
            this.removeValueType();
            return;
        }
        if (state instanceof LinkOfLink) {
            CodelistLink link = ((LinkOfLink)state).target();
            Node target = this.resolve((Named.State)Codes.reveal((CodelistLink)link).state(), Constants.NodeType.CODELINK);
            if (target != null) {
                this.node().createRelationshipTo(target, (RelationshipType)Constants.Relations.LOL);
            }
            return;
        }
        this.node().setProperty("type", (Object)NeoUtils.binder().toXML((Object)state));
    }

    private void removeValueType() {
        Relationship rel;
        if (this.node().hasProperty("type")) {
            this.node().removeProperty("type");
        }
        if ((rel = this.node().getSingleRelationship((RelationshipType)Constants.Relations.LOL, Direction.OUTGOING)) != null) {
            rel.delete();
        }
    }

    public Range range() {
        return this.node().hasProperty("range") ? (Range)NeoUtils.binder().fromXML((String)this.node().getProperty("range")) : Ranges.arbitrarily;
    }

    public void range(Range type) {
        if (type != Ranges.arbitrarily) {
            this.node().setProperty("range", (Object)NeoUtils.binder().toXML((Object)type));
        }
    }

    public ValueFunction function() {
        return this.node().hasProperty("function") ? (ValueFunction)NeoUtils.binder().fromXML((String)this.node().getProperty("function")) : ValueFunctions.identity;
    }

    public void function(ValueFunction type) {
        if (type != ValueFunctions.identity) {
            this.node().setProperty("function", (Object)NeoUtils.binder().toXML((Object)type));
        }
    }
}

