/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cotrix.common.Utils;
import org.cotrix.neo.repository.NeoCriterion;
import org.cotrix.neo.repository.NeoQueryEngine;
import org.cotrix.repository.Range;
import org.cotrix.repository.spi.AbstractMultiQuery;
import org.neo4j.cypher.javacompat.ExecutionResult;

public abstract class NeoMultiQuery<D, R>
extends AbstractMultiQuery<D, R> {
    private final NeoQueryEngine engine;
    private final Map<String, Object> params = new HashMap<String, Object>();
    private final List<String> matches = new ArrayList<String>();
    private final List<String> withs = new ArrayList<String>();
    private final List<String> wheres = new ArrayList<String>();
    private final List<String> orderBys = new ArrayList<String>();
    private final List<String> returns = new ArrayList<String>();
    private String query = null;
    private boolean descending = false;

    public NeoMultiQuery(NeoQueryEngine engine) {
        this.engine = engine;
    }

    public void setDescending() {
        this.descending = true;
    }

    protected void match(String clause) {
        this.matches.add(clause);
    }

    protected void with(String clause) {
        this.withs.add(clause);
    }

    protected void orderBy(String clause) {
        this.orderBys.add(clause);
    }

    protected void where(String clause) {
        this.wheres.add(clause);
    }

    protected void rtrn(String clause) {
        this.returns.add(clause);
    }

    protected void param(String key, Object value) {
        this.params.put(key, value);
    }

    protected synchronized ExecutionResult executeNeo() {
        if (this.query == null) {
            this.query = this.query();
        }
        return this.engine.execute(this.query, this.params);
    }

    private String query() {
        NeoCriterion criterion;
        String response;
        String template = "MATCH %1$s %2$s %3$s RETURN %4$s %5$s %6$s";
        String orderBy = "";
        if (this.criterion() != null && !(response = (criterion = (NeoCriterion)Utils.reveal((Object)this.criterion(), NeoCriterion.class)).process(this)).isEmpty()) {
            orderBy = "ORDER BY " + response;
        }
        String match = NeoMultiQuery.flatten(this.matches);
        for (String exclude : this.excludes()) {
            this.where(String.format("%1$s.%2$s <> '%3$s'", "N", "id", exclude));
        }
        String where = this.excludes().isEmpty() ? "" : "WHERE " + NeoMultiQuery.flatten(this.wheres);
        String with = this.withs.isEmpty() ? "" : "WITH " + NeoMultiQuery.flatten(this.withs);
        String rtrn = NeoMultiQuery.flatten(this.returns);
        String range = "";
        if (this.range() != Range.ALL) {
            this.param("_skip", this.range().from() - 1);
            this.param("_limit", this.range().to() - this.range().from() + 1);
            range = " SKIP {_skip} LIMIT {_limit}";
        }
        String query = String.format(template, match, where, with, rtrn, orderBy, range);
        if (this.descending) {
            query = query.replaceAll("\\bORDER BY\\s*(\\S+)", "ORDER BY $1 DESC");
        }
        return query;
    }

    private static String flatten(List<String> clauses) {
        if (clauses.isEmpty()) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        Iterator<String> it = clauses.iterator();
        while (it.hasNext()) {
            b.append(it.next()).append(it.hasNext() ? ", " : "");
        }
        return b.toString();
    }
}

