/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.domain;

import javax.xml.namespace.QName;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.attributes.CommonDefinition;
import org.cotrix.domain.attributes.Facet;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.trait.Named;
import org.cotrix.neo.domain.Constants;
import org.cotrix.neo.domain.NeoAttributeDefinition;
import org.cotrix.neo.domain.NeoIdentified;
import org.cotrix.neo.domain.utils.NeoStateFactory;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class NeoAttribute
extends NeoIdentified
implements Attribute.Bean {
    public static final NeoStateFactory<Attribute.Bean> factory = new NeoStateFactory<Attribute.Bean>(){

        @Override
        public Attribute.Bean beanFrom(Node node) {
            return new NeoAttribute(node);
        }

        @Override
        public Node nodeFrom(Attribute.Bean state) {
            return new NeoAttribute(state).node();
        }
    };

    public NeoAttribute(Node node) {
        super(node);
    }

    public NeoAttribute(Attribute.Bean state) {
        super(Constants.NodeType.ATTRIBUTE, (Identified.Bean)state);
        this.definition((AttributeDefinition.Bean)state.definition());
        this.value(state.value());
    }

    public AttributeDefinition.Bean definition() {
        if (this.node().hasProperty("cdef")) {
            return CommonDefinition.commonDefinitionFor((String)((String)this.node().getProperty("cdef"))).bean();
        }
        Relationship rel = this.node().getSingleRelationship((RelationshipType)Constants.Relations.INSTANCEOF, Direction.OUTGOING);
        if (rel == null) {
            throw new IllegalStateException(this.id() + " has an orphaned definition link");
        }
        return (AttributeDefinition.Bean)NeoAttributeDefinition.factory.beanFrom(rel.getEndNode());
    }

    public void definition(AttributeDefinition.Bean state) {
        if (CommonDefinition.isCommon((String)state.qname().getLocalPart())) {
            this.node().setProperty("cdef", (Object)state.qname().getLocalPart());
        } else {
            Node target = null;
            if (state.isShared()) {
                target = this.softResolve((Named.Bean)state, Constants.NodeType.ATTRDEF);
            }
            if (target == null) {
                target = NeoAttributeDefinition.factory.nodeFrom(state);
            }
            this.node().createRelationshipTo(target, (RelationshipType)Constants.Relations.INSTANCEOF);
        }
    }

    public QName qname() {
        return this.definition().qname();
    }

    public void qname(QName name) {
        this.definition().qname(name);
    }

    public QName type() {
        return this.definition().type();
    }

    public boolean is(QName name) {
        return this.definition().is(name);
    }

    public boolean is(Facet facet) {
        return this.definition().is(facet);
    }

    public void type(QName type) {
        this.definition().type(type);
    }

    public String value() {
        return (String)this.node().getProperty("val", null);
    }

    public void value(String value) {
        if (value == null) {
            this.node().removeProperty("val");
        } else {
            this.node().setProperty("val", (Object)value);
        }
    }

    public String note() {
        return (String)this.node().getProperty("note", null);
    }

    public void note(String value) {
        if (value == null) {
            this.node().removeProperty("note");
        } else {
            this.node().setProperty("note", (Object)value);
        }
    }

    public String language() {
        return this.definition().language();
    }

    public void language(String language) {
        this.definition().language(language);
    }

    public Attribute.Private entity() {
        return new Attribute.Private((Attribute.Bean)this);
    }
}

