/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.domain;

import org.cotrix.common.async.CancelledTaskException;
import org.cotrix.common.async.TaskContext;
import org.cotrix.common.async.TaskUpdate;
import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.codelist.DefaultVersion;
import org.cotrix.domain.codelist.Version;
import org.cotrix.domain.common.Container;
import org.cotrix.domain.links.LinkDefinition;
import org.cotrix.domain.trait.Described;
import org.cotrix.neo.domain.Constants;
import org.cotrix.neo.domain.NeoAttributeDefinition;
import org.cotrix.neo.domain.NeoCode;
import org.cotrix.neo.domain.NeoDescribed;
import org.cotrix.neo.domain.NeoLinkDefinition;
import org.cotrix.neo.domain.utils.NeoContainer;
import org.cotrix.neo.domain.utils.NeoStateFactory;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeoCodelist
extends NeoDescribed
implements Codelist.Bean {
    private static final Logger log = LoggerFactory.getLogger(NeoCodelist.class);
    public static final NeoStateFactory<Codelist.Bean> factory = new NeoStateFactory<Codelist.Bean>(){

        @Override
        public Codelist.Bean beanFrom(Node node) {
            return new NeoCodelist(node);
        }

        @Override
        public Node nodeFrom(Codelist.Bean state) {
            return new NeoCodelist(state).node();
        }
    };

    public NeoCodelist(Node node) {
        super(node);
    }

    public NeoCodelist(Codelist.Bean other) {
        super(Constants.NodeType.CODELIST, (Described.Bean)other);
        this.version(other.version());
        TaskContext context = new TaskContext();
        float progress = 0.0f;
        int total = other.codes().size() + other.attributeDefinitions().size() + other.linkDefinitions().size();
        for (AttributeDefinition.Bean def : other.attributeDefinitions()) {
            this.node().createRelationshipTo(NeoAttributeDefinition.factory.nodeFrom(def), (RelationshipType)Constants.Relations.DEFINITION);
        }
        context.save((Object)TaskUpdate.update((float)((progress += (float)other.attributeDefinitions().size()) / (float)total), (String)("added " + other.attributeDefinitions().size() + " definitions")));
        for (LinkDefinition.Bean l : other.linkDefinitions()) {
            this.node().createRelationshipTo(NeoLinkDefinition.factory.nodeFrom(l), (RelationshipType)Constants.Relations.LINK);
        }
        context.save((Object)TaskUpdate.update((float)((progress += (float)other.linkDefinitions().size()) / (float)total), (String)("added " + other.linkDefinitions().size() + " links")));
        int i = 0;
        int codes = other.codes().size();
        long step = Math.round(Math.max(10.0, Math.floor(codes / 10)));
        for (Code.Bean c : other.codes()) {
            if ((long)i % step == 0L) {
                if (context.isCancelled()) {
                    log.info("codelist creation aborted on user request after {} codes.", (Object)i);
                    throw new CancelledTaskException("codelist creation aborted on user request");
                }
                context.save((Object)TaskUpdate.update((float)(progress / (float)total), (String)("added " + i + " codes")));
            }
            this.node().createRelationshipTo(NeoCode.factory.nodeFrom(c), (RelationshipType)Constants.Relations.CODE);
            ++i;
            progress += 1.0f;
        }
    }

    public Codelist.Private entity() {
        return new Codelist.Private((Codelist.Bean)this);
    }

    public Version version() {
        return new DefaultVersion((String)this.node().getProperty("ver"));
    }

    public void version(Version version) {
        this.node().setProperty("ver", (Object)version.value());
    }

    public Container.Bean<Code.Bean> codes() {
        return new NeoContainer<Code.Bean>(this.node(), Constants.Relations.CODE, NeoCode.factory);
    }

    public Container.Bean<LinkDefinition.Bean> linkDefinitions() {
        return new NeoContainer<LinkDefinition.Bean>(this.node(), Constants.Relations.LINK, NeoLinkDefinition.factory);
    }

    public Container.Bean<AttributeDefinition.Bean> attributeDefinitions() {
        return new NeoContainer<AttributeDefinition.Bean>(this.node(), Constants.Relations.DEFINITION, NeoAttributeDefinition.factory);
    }
}

