/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.domain.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.common.Container;
import org.cotrix.domain.trait.Named;
import org.cotrix.neo.NeoUtils;
import org.cotrix.neo.domain.Constants;
import org.cotrix.neo.domain.utils.NeoRelationshipIterator;
import org.cotrix.neo.domain.utils.NeoStateFactory;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class NeoContainer<S extends Named.Bean>
implements Container.Bean<S> {
    private final Node owner;
    private final Constants.Relations relation;
    private final NeoStateFactory<S> make;

    public NeoContainer(Node node, Constants.Relations relation, NeoStateFactory<S> factory) {
        this.owner = node;
        this.relation = relation;
        this.make = factory;
    }

    public Iterator<S> iterator() {
        return new NeoRelationshipIterator<S>(this.relationships(), this.make);
    }

    public int size() {
        return CommonUtils.count(this.relationships());
    }

    public void add(S element) {
        this.owner.createRelationshipTo(this.make.nodeFrom(element), (RelationshipType)this.relation);
    }

    public void remove(String id) {
        for (Node n : this.nodes()) {
            if (!id.equals(n.getProperty("id"))) continue;
            NeoUtils.removeNode(n);
            break;
        }
    }

    public S lookup(String id) {
        Node node = this.nodeWith(id);
        return (S)(node == null ? null : (Named.Bean)this.make.beanFrom(node));
    }

    public boolean contains(String id) {
        return this.nodeWith(id) != null;
    }

    public Collection<S> get(Collection<String> ids) {
        ArrayList matches = new ArrayList();
        ArrayList<String> idCopy = new ArrayList<String>(ids);
        for (Node node : this.nodes()) {
            if (!idCopy.contains(this.idOf(node))) continue;
            matches.add(this.make.beanFrom(node));
            idCopy.remove(this.idOf(node));
            if (!idCopy.isEmpty()) continue;
            break;
        }
        return matches;
    }

    public boolean contains(QName name) {
        for (Node node : this.nodes()) {
            Named.Bean bean = (Named.Bean)this.make.beanFrom(node);
            if (!name.equals(bean.qname())) continue;
            return true;
        }
        return false;
    }

    public Collection<S> get(QName name) {
        ArrayList<Named.Bean> matches = new ArrayList<Named.Bean>();
        for (Node n : this.nodes()) {
            Named.Bean bean = (Named.Bean)this.make.beanFrom(n);
            if (!name.equals(bean.qname())) continue;
            matches.add(bean);
        }
        return matches;
    }

    public S getFirst(QName name) throws IllegalStateException {
        for (Node n : this.nodes()) {
            Named.Bean bean = (Named.Bean)this.make.beanFrom(n);
            if (!name.equals(bean.qname())) continue;
            return (S)bean;
        }
        return null;
    }

    private Iterable<Relationship> relationships() {
        return this.owner.getRelationships(Direction.OUTGOING, new RelationshipType[]{this.relation});
    }

    private Iterable<Node> nodes() {
        return new Nodes(this.relationships());
    }

    private Node nodeWith(String id) {
        for (Node n : this.nodes()) {
            if (!id.equals(this.idOf(n))) continue;
            return n;
        }
        return null;
    }

    private String idOf(Node n) {
        return (String)n.getProperty("id", null);
    }

    private class Nodes
    implements Iterable<Node> {
        private final Iterable<Relationship> elements;

        public Nodes(Iterable<Relationship> elements) {
            this.elements = elements;
        }

        @Override
        public Iterator<Node> iterator() {
            final Iterator<Relationship> it = this.elements.iterator();
            return new Iterator<Node>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Node next() {
                    return ((Relationship)it.next()).getEndNode();
                }

                @Override
                public void remove() {
                    ((Relationship)it.next()).delete();
                }
            };
        }
    }
}

