/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.logbook;

import java.util.List;
import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cotrix.application.logbook.Logbook;
import org.cotrix.application.logbook.LogbookService;
import org.cotrix.common.CommonUtils;
import org.cotrix.neo.NeoNodeFactory;
import org.cotrix.neo.domain.Constants;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Alternative
@Priority(value=1000)
public class NeoLogbookService
implements LogbookService.Private {
    private static Logger log = LoggerFactory.getLogger(NeoLogbookService.class);
    @Inject
    private GraphDatabaseService store;

    public void create(Logbook book) {
        CommonUtils.notNull((String)"logbook", (Object)book);
        Node node = this.store.createNode(new Label[]{Constants.NodeType.LOGBOOK});
        node.setProperty("id", (Object)book.resourceId());
        node.setProperty("entries", (Object)CommonUtils.binder().toXML((Object)book.entries()));
    }

    public Logbook logbookOf(String id) {
        CommonUtils.notNull((String)"logbook identifier", (Object)id);
        Node node = NeoNodeFactory.node(Constants.NodeType.LOGBOOK, id);
        if (node == null) {
            return null;
        }
        List entries = (List)CommonUtils.binder().fromXML((String)node.getProperty("entries"));
        return new Logbook((String)node.getProperty("id"), entries);
    }

    public void removeLogbookOf(String id) {
        CommonUtils.notNull((String)"logbook identifier", (Object)id);
        Node node = NeoNodeFactory.node(Constants.NodeType.LOGBOOK, id);
        if (node == null) {
            log.warn("cannot remove codelist logbook for {} (maybe it has already been removed?)", (Object)id);
            return;
        }
        try {
            node.delete();
        }
        catch (Exception e) {
            CommonUtils.rethrow((String)("cannot remove codelist logbook for " + id), (Throwable)e);
        }
        log.info("removed {}'s logbook", (Object)id);
    }

    public void update(Logbook book) {
        CommonUtils.notNull((String)"logbook", (Object)book);
        Node node = NeoNodeFactory.node(Constants.NodeType.LOGBOOK, book.resourceId());
        if (node == null) {
            log.warn("cannot update codelist logbook for {} (maybe it has already been removed?)", (Object)book.resourceId());
        } else {
            node.setProperty("entries", (Object)CommonUtils.binder().toXML((Object)book.entries()));
            log.info("updated {}'s logbook", (Object)book.resourceId());
        }
    }
}

