/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.domain;

import javax.xml.namespace.QName;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.links.Link;
import org.cotrix.domain.links.LinkDefinition;
import org.cotrix.domain.trait.Described;
import org.cotrix.domain.trait.Named;
import org.cotrix.neo.domain.Constants;
import org.cotrix.neo.domain.NeoCode;
import org.cotrix.neo.domain.NeoDescribed;
import org.cotrix.neo.domain.NeoLinkDefinition;
import org.cotrix.neo.domain.utils.NeoStateFactory;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class NeoLink
extends NeoDescribed
implements Link.Bean {
    public static final NeoStateFactory<Link.Bean> factory = new NeoStateFactory<Link.Bean>(){

        @Override
        public Link.Bean beanFrom(Node node) {
            return new NeoLink(node);
        }

        @Override
        public Node nodeFrom(Link.Bean state) {
            return new NeoLink(state).node();
        }
    };

    public NeoLink(Node node) {
        super(node);
    }

    public NeoLink(Link.Bean state) {
        super(Constants.NodeType.CODELINK, (Described.Bean)state);
        this.target(state.target());
        this.definition((LinkDefinition.Bean)state.definition());
    }

    @Override
    public QName qname() {
        LinkDefinition.Bean def = this.definition();
        return def == null ? null : def.qname();
    }

    @Override
    public void qname(QName name) {
    }

    public Link.Private entity() {
        return new Link.Private((Link.Bean)this);
    }

    public Code.Bean target() {
        Relationship rel = this.node().getSingleRelationship((RelationshipType)Constants.Relations.LINK, Direction.OUTGOING);
        return rel == null ? null : (Code.Bean)NeoCode.factory.beanFrom(rel.getEndNode());
    }

    public void target(Code.Bean state) {
        Relationship rel = this.node().getSingleRelationship((RelationshipType)Constants.Relations.LINK, Direction.OUTGOING);
        if (rel != null) {
            rel.delete();
        }
        this.node().createRelationshipTo(this.resolve((Named.Bean)state, Constants.NodeType.CODE), (RelationshipType)Constants.Relations.LINK);
    }

    public LinkDefinition.Bean definition() {
        Relationship rel = this.node().getSingleRelationship((RelationshipType)Constants.Relations.INSTANCEOF, Direction.OUTGOING);
        if (rel == null) {
            throw new IllegalStateException(this.id() + " has an orphaned codelist link");
        }
        return (LinkDefinition.Bean)NeoLinkDefinition.factory.beanFrom(rel.getEndNode());
    }

    public void definition(LinkDefinition.Bean state) {
        this.node().createRelationshipTo(this.resolve((Named.Bean)state, Constants.NodeType.LINKDEF), (RelationshipType)Constants.Relations.INSTANCEOF);
    }
}

