/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.repository;

import javax.xml.namespace.QName;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.trait.Named;

public class CodelistCoordinates
implements Named {
    private final String id;
    private final QName name;
    private final String version;

    public static CodelistCoordinates coords(String id, QName name, String version) {
        return new CodelistCoordinates(id, name, version);
    }

    public static CodelistCoordinates coordsOf(Codelist.State list) {
        return new CodelistCoordinates(list.id(), list.name(), list.version().value());
    }

    public static CodelistCoordinates coordsOf(Codelist list) {
        return new CodelistCoordinates(list.id(), list.name(), list.version());
    }

    public CodelistCoordinates(String id, QName name, String version) {
        this.id = id;
        this.name = name;
        this.version = version;
    }

    public String id() {
        return this.id;
    }

    public QName name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public String toString() {
        return "[name=" + this.name + ", version=" + this.version + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodelistCoordinates other = (CodelistCoordinates)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

