/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.repository.impl;

import org.cotrix.common.Utils;
import org.cotrix.domain.trait.EntityProvider;
import org.cotrix.domain.trait.Identified;
import org.cotrix.repository.Query;
import org.cotrix.repository.Repository;
import org.cotrix.repository.UpdateAction;
import org.cotrix.repository.impl.EventProducer;
import org.cotrix.repository.spi.StateRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRepository<T extends Identified, P extends Identified.Abstract<P, S>, S extends Identified.State & EntityProvider<P>>
implements Repository<T> {
    private static Logger log = LoggerFactory.getLogger(Repository.class);
    private final StateRepository<S> delegate;
    private final EventProducer producer;

    public AbstractRepository(StateRepository<S> repository, EventProducer producer) {
        Utils.notNull((String)"delegate repository", repository);
        Utils.notNull((String)"event producer", (Object)producer);
        this.delegate = repository;
        this.producer = producer;
    }

    @Override
    public void add(T entity) {
        Utils.notNull((String)"entity", entity);
        Identified.Abstract implementation = (Identified.Abstract)this.retype(entity);
        if (implementation.isChangeset()) {
            throw new IllegalArgumentException("entity " + this.log(entity) + "is a changeset and cannot be added");
        }
        if (this.delegate.contains(implementation.id())) {
            throw new IllegalArgumentException("entity " + this.log(entity) + "is already in this repository");
        }
        this.delegate.add(implementation.state());
        log.trace("added entity {}", (Object)this.log(entity));
        this.producer.additions.fire(entity);
    }

    @Override
    public T lookup(String id) {
        Utils.valid((String)"entity identifier", (String)id);
        Identified.State state = (Identified.State)this.delegate.lookup(id);
        if (state == null) {
            return null;
        }
        return (T)((Identified)this.retype(((EntityProvider)state).entity()));
    }

    @Override
    public <R> R get(Query<T, R> query) {
        Utils.notNull((String)"query", query);
        return this.reveal(query).execute();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public void update(T changeset) {
        Utils.notNull((String)"changeset", changeset);
        Identified.Abstract implementation = (Identified.Abstract)this.retype(changeset);
        if (!implementation.isChangeset()) {
            throw new IllegalArgumentException(this.log(changeset) + "is not a changeset");
        }
        Identified.State state = (Identified.State)this.delegate.lookup(implementation.id());
        if (state == null) {
            throw new IllegalStateException(this.log(changeset) + " is not in this repository, hence cannot be updated.");
        }
        Identified.Abstract entity = (Identified.Abstract)((EntityProvider)state).entity();
        entity.update(implementation);
        this.producer.updates.fire(changeset);
    }

    @Override
    public void update(String id, UpdateAction<T> action) {
        Utils.notNull((String)"codelist identifier", (Object)id);
        Utils.notNull((String)"update action", action);
        T entity = this.lookup(id);
        if (entity == null) {
            throw new IllegalStateException("entity " + id + " is not in this repository, hence cannot be updated.");
        }
        long time = System.currentTimeMillis();
        try {
            action.performOver(entity);
        }
        catch (Exception e) {
            Utils.rethrow((String)("cannot perform " + action + " (see cause) "), (Throwable)e);
        }
        log.trace("performed {} over {} in {} ms.", new Object[]{action, this.log(entity), System.currentTimeMillis() - time});
    }

    @Override
    public void remove(String id) {
        Utils.valid((String)"entity identifier", (String)id);
        if (!this.delegate.contains(id)) {
            throw new IllegalStateException("entity " + id + " is not in this repository, hence cannot be removed.");
        }
        this.delegate.remove(id);
        log.info("removed entity " + id);
        this.producer.removals.fire((Object)id);
    }

    private <R> Query.Private<T, R> reveal(Query<T, R> query) {
        return (Query.Private)Utils.reveal(query, Query.Private.class);
    }

    public <A, B> A retype(B entity) {
        return (A)entity;
    }

    public String log(T entity) {
        return entity.id() + " (" + entity.getClass().getName() + ") ";
    }
}

