/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import javax.inject.Inject;
import org.cotrix.action.Action;
import org.cotrix.action.Actions;
import org.cotrix.action.ResourceType;
import org.cotrix.common.Utils;
import org.cotrix.domain.dsl.Roles;
import org.cotrix.domain.dsl.Users;
import org.cotrix.domain.dsl.grammar.UserGrammar;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;
import org.cotrix.repository.UserRepository;
import org.cotrix.test.ApplicationTest;
import org.junit.Assert;
import org.junit.Test;

public class UserRepositoryCrudTest
extends ApplicationTest {
    @Inject
    UserRepository repository;

    @Test
    public void addAndRetrieveUser() {
        User bill = this.bill();
        this.repository.add((Object)bill);
        User retrieved = (User)this.repository.lookup(bill.id());
        Assert.assertEquals((Object)bill, (Object)retrieved);
    }

    @Test
    public void deleteUser() {
        User bill = this.bill();
        this.repository.add((Object)bill);
        this.repository.remove(bill.id());
        Assert.assertNull((Object)this.repository.lookup(bill.id()));
    }

    @Test
    public void updateUser() {
        Action doit = Actions.action((String)"doit", (String[])new String[0]);
        Role role = Roles.role((String)"role").buildAsRoleFor(ResourceType.application);
        User bill = this.bill();
        this.repository.add((Object)bill);
        bill = (User)this.repository.lookup(bill.id());
        User changeset = Users.modifyUser((User)bill).can(new Action[]{doit}).is(new Role[]{role}).build();
        this.update(bill, changeset);
        bill = (User)this.repository.lookup(bill.id());
        Assert.assertTrue((boolean)bill.can(doit));
        Assert.assertTrue((boolean)bill.is(role));
    }

    private User bill() {
        return this.aUser("bill").build();
    }

    private UserGrammar.ThirdClause aUser(String name) {
        return Users.user().name(name).fullName(name).noMail();
    }

    private void update(User bill, User changeset) {
        ((User.Private)Utils.reveal((Object)bill, User.Private.class)).update((User.Private)Utils.reveal((Object)changeset, User.Private.class));
    }
}

