/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.repository.impl.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.trait.Identified;
import org.cotrix.repository.Criterion;
import org.cotrix.repository.Range;
import org.cotrix.repository.impl.memory.MemoryRepository;
import org.cotrix.repository.spi.AbstractMultiQuery;

public abstract class MMultiQuery<T, R>
extends AbstractMultiQuery<T, R> {
    abstract Collection<? extends R> executeInMemory();

    @Override
    public Iterator<R> iterator() {
        ArrayList<R> results = new ArrayList<R>(this.executeInMemory());
        ArrayList excludes = new ArrayList();
        for (Object result : results) {
            if (!(result instanceof Identified) || !this.excludes().contains(((Identified)Identified.class.cast(result)).id())) continue;
            excludes.add(result);
        }
        results.removeAll(excludes);
        if (this.criterion() != null) {
            Collections.sort(results, this.reveal(this.criterion()));
        }
        int count = 1;
        ArrayList<Object> range = new ArrayList<Object>();
        if (this.range() == Range.ALL) {
            range.addAll(results);
        } else {
            for (Object result : results) {
                if (count < this.range().from()) {
                    ++count;
                    continue;
                }
                if (count > this.range().to()) break;
                range.add(result);
                ++count;
            }
        }
        return range.iterator();
    }

    private MemoryRepository.MCriterion<R> reveal(Criterion<R> criterion) {
        return (MemoryRepository.MCriterion)CommonUtils.reveal(criterion, MemoryRepository.MCriterion.class);
    }
}

