/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.repository.impl.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Observes;
import org.cotrix.common.CommonUtils;
import org.cotrix.common.events.ApplicationLifecycleEvents;
import org.cotrix.domain.trait.BeanOf;
import org.cotrix.domain.trait.Identified;
import org.cotrix.repository.Criterion;
import org.cotrix.repository.spi.StateRepository;

public abstract class MemoryRepository<S extends Identified.Bean>
implements StateRepository<S> {
    private final Map<String, S> objects = new HashMap<String, S>();

    @Override
    public void add(S object) {
        this.objects.put(object.id(), object);
    }

    @Override
    public S lookup(String id) {
        return (S)((Identified.Bean)this.objects.get(id));
    }

    @Override
    public boolean contains(String id) {
        return this.objects.containsKey(id);
    }

    @Override
    public void remove(String id) {
        this.objects.remove(id);
    }

    public List<S> getAll() {
        return new ArrayList<S>(this.objects.values());
    }

    @Override
    public int size() {
        return this.objects.size();
    }

    public <T> Criterion<T> all(final Criterion<T> c1, final Criterion<T> c2) {
        return new MCriterion<T>(){

            @Override
            public int compare(T o1, T o2) {
                int result = MemoryRepository.reveal(c1).compare(o1, o2);
                if (result == 0) {
                    result = MemoryRepository.reveal(c2).compare(o1, o2);
                }
                return result;
            }
        };
    }

    public <T> Criterion<T> descending(final Criterion<T> c) {
        return new MCriterion<T>(){

            @Override
            public int compare(T o1, T o2) {
                return -1 * MemoryRepository.reveal(c).compare(o1, o2);
            }
        };
    }

    public <R, SR extends BeanOf<? extends R>> Collection<R> adapt(Collection<SR> results) {
        ArrayList<Object> adapted = new ArrayList<Object>();
        for (BeanOf result : results) {
            adapted.add(result.entity());
        }
        return adapted;
    }

    public void clear(@Observes ApplicationLifecycleEvents.Shutdown event) {
        this.objects.clear();
    }

    private static <R> MCriterion<R> reveal(Criterion<R> criterion) {
        return (MCriterion)CommonUtils.reveal(criterion, MCriterion.class);
    }

    public static interface MCriterion<T>
    extends Comparator<T>,
    Criterion<T> {
    }
}

