/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.repository.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.utils.DomainConstants;

public class Fingerprint {
    private final Map<QName, Map<QName, Set<String>>> data = new HashMap<QName, Map<QName, Set<String>>>();

    public Fingerprint addAttributes(Iterable<? extends Attribute> attributes) {
        for (Attribute attribute : attributes) {
            if (attribute.is(DomainConstants.SYSTEM_TYPE)) continue;
            Fingerprint.addAttributeTo(this.typesFor(attribute.qname()), attribute.type(), attribute.language());
        }
        return this;
    }

    public Fingerprint addDefinitions(Iterable<? extends AttributeDefinition> definitions) {
        for (AttributeDefinition attributeDefinition : definitions) {
            if (attributeDefinition.is(DomainConstants.SYSTEM_TYPE)) continue;
            Fingerprint.addAttributeTo(this.typesFor(attributeDefinition.qname()), attributeDefinition.type(), attributeDefinition.language());
        }
        return this;
    }

    public Collection<QName> attributeNames() {
        return this.data.keySet();
    }

    public Map<QName, Set<String>> typesFor(QName name) {
        Map<QName, Set<String>> types = this.data.get(name);
        if (types == null) {
            types = new HashMap<QName, Set<String>>();
            this.data.put(name, types);
        }
        return types;
    }

    public Collection<String> languagesFor(QName name, QName type) {
        if (this.data.containsKey(name) && this.data.get(name).containsKey(type)) {
            return this.typesFor(name).get(type);
        }
        return Collections.emptySet();
    }

    private static void addAttributeTo(Map<QName, Set<String>> types, QName type, String language) {
        Set<String> langForType = types.get(type);
        if (langForType == null) {
            langForType = new HashSet<String>();
            types.put(type, langForType);
        }
        if (language != null) {
            langForType.add(language);
        }
    }
}

