/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.repository.impl;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.utils.DomainUtils;
import org.cotrix.repository.CodelistRepository;
import org.cotrix.repository.impl.AbstractRepository;
import org.cotrix.repository.impl.EventProducer;
import org.cotrix.repository.spi.StateRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class BaseCodelistRepository
extends AbstractRepository<Codelist, Codelist.Private, Codelist.Bean>
implements CodelistRepository {
    private static Logger log = LoggerFactory.getLogger(CodelistRepository.class);

    @Inject
    public BaseCodelistRepository(StateRepository<Codelist.Bean> repository, EventProducer producer) {
        super(repository, producer);
    }

    @Override
    public void add(Codelist list) {
        long time = System.currentTimeMillis();
        super.add(list);
        time = System.currentTimeMillis() - time;
        log.trace("added codelist {} in {} msecs, roughly {} codes/sec", new Object[]{DomainUtils.signatureOf((Codelist)list), time, Float.valueOf((float)list.codes().size() / (float)time * 1000.0f)});
    }

    @Override
    public void add(CodelistGrammar.SecondClause list) {
        this.add((Codelist)list.build());
    }

    @Override
    public void update(CodelistGrammar.SecondClause changeset) {
        this.update((Identified)changeset.build());
    }
}

