/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.security.impl;

import java.util.Iterator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.cotrix.common.cdi.BeanSession;
import org.cotrix.common.cdi.Current;
import org.cotrix.domain.dsl.Users;
import org.cotrix.domain.user.User;
import org.cotrix.repository.UserQueries;
import org.cotrix.repository.UserRepository;
import org.cotrix.security.InvalidCredentialsException;
import org.cotrix.security.LoginService;
import org.cotrix.security.Realm;
import org.cotrix.security.TokenCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultLoginService
implements LoginService {
    private static Logger log = LoggerFactory.getLogger(LoginService.class);
    @Inject
    private Instance<TokenCollector> collectors;
    @Inject
    @Any
    private Instance<Realm> realms;
    @Inject
    private UserRepository users;
    @Inject
    @Current
    private BeanSession session;

    @Override
    public User login(HttpServletRequest request) {
        Object token = this.collectTokenFrom(request);
        User user = null;
        if (token == null) {
            user = Users.guest;
        } else {
            String identity = this.identifyFrom(token);
            if (identity == null) {
                throw new InvalidCredentialsException();
            }
            if (identity.equals(Users.cotrix.name())) {
                user = Users.cotrix;
            } else {
                user = (User)this.users.get(UserQueries.userByName((String)identity));
                if (user == null) {
                    throw new InvalidCredentialsException();
                }
            }
            log.info("user {} has logged in", (Object)user.name());
        }
        this.session.add(User.class, (Object)user);
        return user;
    }

    private Object collectTokenFrom(HttpServletRequest request) {
        Object token = null;
        Iterator it = this.collectors.iterator();
        while (it.hasNext() && token == null) {
            token = ((TokenCollector)it.next()).token(request);
        }
        return token;
    }

    private String identifyFrom(Object token) {
        Realm authenticator;
        Iterator it = this.realms.iterator();
        String id = null;
        while (it.hasNext() && id == null && (!(authenticator = (Realm)it.next()).supports(token) || (id = authenticator.login(token)) == null)) {
        }
        return id;
    }
}

