/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.security.impl;

import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.cotrix.action.Action;
import org.cotrix.action.MainAction;
import org.cotrix.action.UserAction;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.dsl.Roles;
import org.cotrix.domain.dsl.Users;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;
import org.cotrix.repository.UserRepository;
import org.cotrix.security.SignupService;
import org.cotrix.security.events.SignupEvent;
import org.cotrix.security.impl.NativeRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSignupService
implements SignupService {
    private static Logger log = LoggerFactory.getLogger(DefaultSignupService.class);
    @Inject
    private NativeRealm realm;
    @Inject
    private UserRepository repository;
    @Inject
    private Event<SignupEvent> events;

    @Override
    public void signup(User user, String pwd) {
        CommonUtils.notNull((String)"user", (Object)user);
        CommonUtils.notNull((String)"password", (Object)pwd);
        this.realm.add(user.name(), pwd);
        this.repository.add((Object)user);
        User changeset = Users.modifyUser((User)user).is(new Role[]{Roles.USER}).can(new Action[]{MainAction.LOGOUT, UserAction.EDIT.on(user.id()), UserAction.VIEW.on(user.id()), UserAction.CHANGE_PASSWORD.on(user.id())}).build();
        this.repository.update((Object)changeset);
        log.info("{} has signed up", (Object)user.name());
        this.events.fire((Object)new SignupEvent(user));
    }

    @Override
    public void changePassword(User user, String oldPwd, String newPwd) {
        CommonUtils.notNull((String)"user", (Object)user);
        CommonUtils.notNull((String)"current password", (Object)oldPwd);
        CommonUtils.notNull((String)"new password", (Object)newPwd);
        this.realm.update(user.name(), oldPwd, newPwd);
        log.info("user {} has changed password", (Object)user.name());
    }
}

