/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.security.impl;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Priority;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import org.cotrix.common.events.ApplicationLifecycleEvents;
import org.cotrix.security.impl.NativeRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alternative
@Priority(value=1)
public class MRealm
extends NativeRealm {
    private static Logger log = LoggerFactory.getLogger(MRealm.class);
    private Map<String, String> pwds = new HashMap<String, String>();

    @Override
    protected String passwordFor(String name) {
        return this.pwds.get(name);
    }

    @Override
    protected void create(String name, String pwd) {
        this.update(name, pwd);
    }

    @Override
    protected void update(String name, String pwd) {
        this.pwds.put(name, pwd);
    }

    void clear() {
        log.trace("clearing inner realm");
        this.pwds.clear();
    }

    public static void clear(@Observes ApplicationLifecycleEvents.Shutdown event, NativeRealm realm) {
        if (realm instanceof MRealm) {
            ((MRealm)MRealm.class.cast(realm)).clear();
        }
    }
}

