/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import org.acme.DomainTest;
import org.acme.codelists.Fixture;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.common.Attribute;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.dsl.grammar.CodeGrammar;
import org.cotrix.domain.memory.CodeMS;
import org.cotrix.domain.trait.Status;
import org.junit.Assert;
import org.junit.Test;

public class CodeTest
extends DomainTest {
    @Test
    public void codesCanBeFluentlyConstructed() {
        Code code = (Code)((CodeGrammar.SecondClause)Codes.code().name(Fixture.name)).build();
        Assert.assertEquals((Object)Fixture.name, (Object)code.name());
        Attribute a = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).ofType(Fixture.type).build();
        code = (Code)((CodeGrammar.FinalClause)((CodeGrammar.SecondClause)Codes.code().name(Fixture.name)).attributes(new Attribute[]{a})).build();
        Assert.assertTrue((boolean)code.attributes().contains((Object)a));
    }

    @Test
    public void changesetsCanBeFluentlyConstructed() {
        Attribute a = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name("name")).build();
        Attribute added = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name("name")).build();
        Attribute modified = (Attribute)((AttributeGrammar.ValueClause)Codes.modifyAttribute((String)"1").name("name")).build();
        Attribute deleted = Codes.deleteAttribute((String)"1");
        Code c = (Code)((CodeGrammar.SecondClause)Codes.code().name(Fixture.name)).build();
        c = (Code)((CodeGrammar.FinalClause)((CodeGrammar.SecondClause)Codes.code().name(Fixture.name)).attributes(new Attribute[]{a})).build();
        Assert.assertEquals(null, (Object)Codes.reveal((Code)c).status());
        c = (Code)((CodeGrammar.FinalClause)Codes.modifyCode((String)"1").attributes(new Attribute[]{modified, added, deleted})).build();
        Assert.assertEquals((Object)Status.MODIFIED, (Object)Codes.reveal((Code)c).status());
        c = Codes.deleteCode((String)"1");
        Assert.assertEquals((Object)Status.DELETED, (Object)Codes.reveal((Code)c).status());
    }

    @Test
    public void cloned() {
        Attribute a = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).ofType(Fixture.type).in(Fixture.language).build();
        Code c = (Code)this.like(((CodeGrammar.FinalClause)((CodeGrammar.SecondClause)Codes.code().name(Fixture.name)).attributes(new Attribute[]{a})).build());
        Code.State state = (Code.State)Codes.reveal((Code)c).state();
        CodeMS clone = new CodeMS(state);
        Assert.assertEquals((Object)clone, (Object)state);
    }

    @Test
    public void changeName() {
        Code code = (Code)this.like(((CodeGrammar.SecondClause)Codes.code().name(Fixture.name)).build());
        Code changeset = (Code)((CodeGrammar.SecondClause)Codes.modifyCode((String)code.id()).name(Fixture.name2)).build();
        Codes.reveal((Code)code).update(Codes.reveal((Code)changeset));
        Assert.assertEquals((Object)Fixture.name2, (Object)code.name());
    }

    @Test
    public void addAttribute() {
        Code code = (Code)this.like(((CodeGrammar.SecondClause)Codes.code().name(Fixture.name)).build());
        Attribute added = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).build();
        Assert.assertFalse((boolean)code.attributes().contains((Object)added));
        Code changeset = (Code)((CodeGrammar.FinalClause)Codes.modifyCode((String)code.id()).attributes(new Attribute[]{added})).build();
        Codes.reveal((Code)code).update(Codes.reveal((Code)changeset));
        Assert.assertTrue((boolean)code.attributes().contains((Object)added));
    }

    @Test
    public void removeAttribute() {
        Attribute a = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).build();
        Code code = (Code)this.like(((CodeGrammar.FinalClause)((CodeGrammar.SecondClause)Codes.code().name(Fixture.name)).attributes(new Attribute[]{a})).build());
        Assert.assertTrue((boolean)code.attributes().contains((Object)a));
        Attribute deleted = Codes.deleteAttribute((String)a.id());
        Code changeset = (Code)((CodeGrammar.FinalClause)Codes.modifyCode((String)code.id()).attributes(new Attribute[]{deleted})).build();
        Codes.reveal((Code)code).update(Codes.reveal((Code)changeset));
        Assert.assertFalse((boolean)code.attributes().contains((Object)a));
    }

    @Test
    public void updateAttribute() {
        Attribute a = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).build();
        Code code = (Code)this.like(((CodeGrammar.FinalClause)((CodeGrammar.SecondClause)Codes.code().name(Fixture.name)).attributes(new Attribute[]{a})).build());
        Assert.assertTrue((boolean)code.attributes().contains((Object)a));
        Attribute modified = (Attribute)((AttributeGrammar.ValueClause)Codes.modifyAttribute((String)a.id()).name(Fixture.name2)).build();
        Code changeset = (Code)((CodeGrammar.FinalClause)Codes.modifyCode((String)code.id()).attributes(new Attribute[]{modified})).build();
        Codes.reveal((Code)code).update(Codes.reveal((Code)changeset));
        Assert.assertNotNull((Object)code.attributes().lookup(Fixture.name2));
    }
}

