/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import org.acme.DomainTest;
import org.cotrix.domain.memory.AttributedMS;
import org.cotrix.domain.trait.Attributed;
import org.cotrix.domain.trait.Status;
import org.cotrix.domain.utils.Constants;
import org.junit.Assert;
import org.junit.Test;

public class AttributedTest
extends DomainTest {
    @Test
    public void attributesMustBeValid() {
        AttributedMS state = new AttributedMS();
        try {
            state.attributes(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void creationTimeIsTracked() {
        Attributed e = (Attributed)this.like(new MyEntity(new AttributedMS()));
        Assert.assertTrue((boolean)e.attributes().contains(Constants.CREATION_TIME));
    }

    @Test
    public void creationTimeIsNotTrackedOnChangesets() {
        Attributed e = (Attributed)this.like(new MyEntity(new AttributedMS("someid", Status.MODIFIED)));
        Assert.assertFalse((boolean)e.attributes().contains(Constants.CREATION_TIME));
    }

    @Test
    public void updateTimeIsTracked() {
        Attributed.Abstract e = this.like(new MyEntity(new AttributedMS()));
        MyEntity changeset = new MyEntity(new AttributedMS(e.id(), Status.MODIFIED));
        e.update((Attributed.Abstract)changeset);
        Assert.assertTrue((boolean)e.attributes().contains(Constants.UPDATE_TIME));
        e.update((Attributed.Abstract)changeset);
        Assert.assertEquals((long)1L, (long)e.attributes().getAll(Constants.UPDATE_TIME).size());
    }

    static class MyEntity
    extends Attributed.Abstract<MyEntity, AttributedMS> {
        public MyEntity(AttributedMS state) {
            super((Attributed.State)state);
        }
    }
}

