/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import org.acme.DomainTest;
import org.cotrix.domain.attributes.CommonDefinition;
import org.cotrix.domain.memory.AttributedMS;
import org.cotrix.domain.trait.Attributed;
import org.cotrix.domain.trait.Status;
import org.junit.Assert;
import org.junit.Test;

public class AttributedTest
extends DomainTest {
    @Test
    public void attributesMustBeValid() {
        AttributedMS state = new AttributedMS();
        try {
            state.attributes(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void creationTimeIsTracked() {
        Attributed e = (Attributed)this.like(new MyEntity(new AttributedMS()));
        Assert.assertTrue((boolean)e.attributes().contains(CommonDefinition.CREATION_TIME.qname()));
        Assert.assertEquals((long)1L, (long)e.attributes().getAll(CommonDefinition.CREATION_TIME.qname()).size());
    }

    @Test
    public void creationTimeIsNotTrackedOnChangesets() {
        Attributed e = (Attributed)this.like(new MyEntity(new AttributedMS("someid", Status.MODIFIED)));
        Assert.assertFalse((boolean)e.attributes().contains(CommonDefinition.CREATION_TIME.qname()));
    }

    @Test
    public void updateTimeIsTracked() {
        Attributed.Abstract e = this.like(new MyEntity(new AttributedMS()));
        MyEntity changeset = new MyEntity(new AttributedMS(e.id(), Status.MODIFIED));
        e.update((Attributed.Abstract)changeset);
        Assert.assertTrue((boolean)e.attributes().contains(CommonDefinition.UPDATE_TIME.qname()));
        Assert.assertEquals((long)1L, (long)e.attributes().getAll(CommonDefinition.UPDATE_TIME.qname()).size());
        e.update((Attributed.Abstract)changeset);
        Assert.assertEquals((long)1L, (long)e.attributes().getAll(CommonDefinition.UPDATE_TIME.qname()).size());
    }

    static class MyEntity
    extends Attributed.Abstract<MyEntity, AttributedMS> {
        public MyEntity(AttributedMS state) {
            super((Attributed.State)state);
        }
    }
}

