/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import org.acme.DomainTest;
import org.acme.codelists.Fixture;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.Definition;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelink;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.codelist.CodelistLink;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.dsl.grammar.CodeGrammar;
import org.cotrix.domain.dsl.grammar.CodelinkGrammar;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.domain.dsl.grammar.CodelistLinkGrammar;
import org.cotrix.domain.dsl.grammar.CommonClauses;
import org.cotrix.domain.dsl.grammar.DefinitionGrammar;
import org.cotrix.domain.memory.CodeMS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CodeTest
extends DomainTest {
    Attribute attr = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name(Fixture.name)).build();
    Definition def = (Definition)((DefinitionGrammar.OptionalClause)Codes.definition().name(Fixture.name2)).build();
    Attribute a1 = (Attribute)Codes.attribute().with(this.def).value("val1").build();
    Attribute a2 = (Attribute)Codes.attribute().with(this.def).value("val2").build();
    Code targetcode = (Code)((CodeGrammar.OptionalClause)Codes.code().name(Fixture.name2)).build();
    Codelist target = (Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name(Fixture.name)).with((Object[])new Code[]{this.targetcode})).build();
    CodelistLink listlink = (CodelistLink)((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name(Fixture.name)).target((Object)this.target)).build();
    Codelink link = (Codelink)((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(this.listlink).target((Object)this.targetcode)).build();
    Code code = (Code)((CodeGrammar.OptionalClause)((CodeGrammar.OptionalClause)((CodeGrammar.OptionalClause)Codes.code().name(Fixture.name)).attributes(new Attribute[]{this.attr, this.a1, this.a2})).links((Object[])new Codelink[]{this.link})).build();

    @Before
    public void stage() {
        this.target = this.like(this.target);
        this.def = this.like(this.def);
        this.listlink = this.like(this.listlink);
        this.code = this.like(this.code);
    }

    @Test
    public void codesCanBeFluentlyConstructed() {
        Code minimal = (Code)((CodeGrammar.OptionalClause)Codes.code().name(Fixture.name)).build();
        Assert.assertNotNull((Object)minimal.attributes());
        Assert.assertNotNull((Object)minimal.links());
        Assert.assertTrue((boolean)this.code.attributes().contains((Object)this.attr));
        Assert.assertTrue((boolean)this.code.links().contains((Object)this.link));
        Assert.assertTrue((boolean)this.code.attributes().contains((Object)this.attr));
        Assert.assertTrue((boolean)this.a1.definition().isShared());
        Assert.assertFalse((boolean)this.attr.definition().isShared());
    }

    @Test
    public void changesetsCanBeFluentlyConstructed() {
        ((CodeGrammar.OptionalClause)Codes.modify((Code)this.code).name(Fixture.name)).build();
        ((CodeGrammar.OptionalClause)Codes.modify((Code)this.code).attributes(new Attribute[]{this.attr})).build();
        ((CodeGrammar.OptionalClause)Codes.modify((Code)this.code).links((Object[])new Codelink[]{this.link})).build();
        Codes.delete((Code)this.code);
    }

    @Test
    public void canBeCloned() {
        Code.State state = (Code.State)Codes.reveal((Code)this.code).state();
        CodeMS clone = new CodeMS(state);
        Assert.assertEquals((Object)state.name(), (Object)clone.name());
        Assert.assertTrue((boolean)clone.attributes().contains(this.attr.name()));
        Assert.assertTrue((boolean)clone.links().contains(this.link.name()));
    }

    @Test
    public void canBeUpdated() {
        Code changeset = (Code)((CodeGrammar.OptionalClause)((CodeGrammar.OptionalClause)((CodeGrammar.OptionalClause)Codes.modify((Code)this.code).name(Fixture.name2)).attributes(new Attribute[]{Codes.delete((Attribute)this.attr)})).links((Object[])new Codelink[]{Codes.delete((Codelink)this.link)})).build();
        Codes.reveal((Code)this.code).update(Codes.reveal((Code)changeset));
        Assert.assertEquals((Object)changeset.name(), (Object)this.code.name());
        Assert.assertFalse((boolean)this.code.attributes().contains(this.attr.name()));
        Assert.assertFalse((boolean)this.code.links().contains(this.link.name()));
    }
}

