/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import javax.xml.namespace.QName;
import org.acme.DomainTest;
import org.acme.codelists.Fixture;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.codelist.CodelistLink;
import org.cotrix.domain.common.Ranges;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.domain.dsl.grammar.CodelistLinkGrammar;
import org.cotrix.domain.dsl.grammar.CommonClauses;
import org.cotrix.domain.links.AttributeLink;
import org.cotrix.domain.links.LinkOfLink;
import org.cotrix.domain.links.NameLink;
import org.cotrix.domain.memory.CodelistLinkMS;
import org.cotrix.domain.trait.Status;
import org.cotrix.domain.utils.AttributeTemplate;
import org.cotrix.domain.values.ValueFunction;
import org.cotrix.domain.values.ValueFunctions;
import org.junit.Assert;
import org.junit.Test;

public class CodelistLinkTest
extends DomainTest {
    @Test
    public void linksCanBeFluentlyConstructed() {
        Codelist target = this.someCodelist(new QName[0]);
        Attribute a = this.someAttribute(new QName[0]);
        CodelistLink newlink = (CodelistLink)((CodelistLinkGrammar.OptionalClause)((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name(Fixture.name)).target((Object)target)).attributes(new Attribute[]{a})).build();
        Assert.assertEquals((Object)Fixture.name, (Object)newlink.name());
        Assert.assertEquals((Object)target, (Object)newlink.target());
        Assert.assertTrue((boolean)newlink.attributes().contains((Object)a));
        Assert.assertEquals((Object)NameLink.INSTANCE, (Object)newlink.valueType());
        Assert.assertEquals((Object)ValueFunctions.identity, (Object)((CodelistLink.State)Codes.reveal((CodelistLink)newlink).state()).function());
        Assert.assertEquals((Object)Ranges.arbitrarily, (Object)((CodelistLink.State)Codes.reveal((CodelistLink)newlink).state()).range());
        newlink = (CodelistLink)((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name(Fixture.name)).target((Object)target)).anchorToName().build();
        Assert.assertEquals((Object)NameLink.INSTANCE, (Object)newlink.valueType());
        Attribute template = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name(Codes.q((String)"this"))).ofType(Codes.q((String)"that")).in("this").build();
        newlink = (CodelistLink)((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name(Fixture.name)).target((Object)target)).anchorTo(template).build();
        Assert.assertEquals((Object)new AttributeLink(new AttributeTemplate(template)), (Object)newlink.valueType());
        CodelistLink linktemplate = (CodelistLink)((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name(Fixture.name)).target((Object)target)).anchorTo(template).build();
        newlink = (CodelistLink)((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name(Fixture.name)).target((Object)target)).anchorTo(linktemplate).build();
        Assert.assertEquals((Object)new LinkOfLink(linktemplate), (Object)newlink.valueType());
        newlink = (CodelistLink)((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name(Fixture.name)).target((Object)target)).transformWith(ValueFunctions.lowercase).build();
        Assert.assertEquals((Object)ValueFunctions.lowercase, (Object)((CodelistLink.State)Codes.reveal((CodelistLink)newlink).state()).function());
        newlink = (CodelistLink)((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name(Fixture.name)).target((Object)target)).occurs(Ranges.atmost((int)5)).build();
        Assert.assertEquals((Object)Ranges.atmost((int)5), (Object)((CodelistLink.State)Codes.reveal((CodelistLink)newlink).state()).range());
    }

    @Test
    public void changesetCanBeFluentlyConstructed() {
        CodelistLink link = (CodelistLink)((CodelistLinkGrammar.OptionalClause)Codes.modifyListLink((String)"1").name(Fixture.name)).build();
        link = (CodelistLink)((CodelistLinkGrammar.OptionalClause)Codes.modifyListLink((String)"1").attributes(new Attribute[]{this.someAttribute(new QName[0])})).build();
        link = (CodelistLink)Codes.modifyListLink((String)"1").anchorTo(this.someTemplate(new QName[0])).build();
        link = (CodelistLink)Codes.modifyListLink((String)"1").anchorToName().build();
        CodelistLink linktemplate = (CodelistLink)((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name(Fixture.name)).target((Object)this.someCodelist(new QName[0]))).build();
        link = (CodelistLink)Codes.modifyListLink((String)"1").anchorTo(linktemplate).build();
        link = (CodelistLink)Codes.modifyListLink((String)"1").transformWith(ValueFunctions.uppercase).build();
        link = (CodelistLink)Codes.modifyListLink((String)"1").occurs(Ranges.atmostonce).build();
        link = (CodelistLink)((CodelistLinkGrammar.OptionalClause)((CodelistLinkGrammar.OptionalClause)Codes.modifyListLink((String)"1").name(Fixture.name)).attributes(new Attribute[]{this.someAttribute(new QName[0])})).anchorTo(this.someTemplate(new QName[0])).transformWith(ValueFunctions.lowercase).occurs(Ranges.atmostonce).build();
        Assert.assertEquals((Object)Status.MODIFIED, (Object)((CodelistLink.Private)link).status());
    }

    @Test
    public void linksCanBeCloned() {
        CodelistLink fullLinkWithoutDefaults = (CodelistLink)this.like(((CodelistLinkGrammar.OptionalClause)((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name(Fixture.name)).target((Object)this.someCodelist(new QName[0]))).anchorTo(this.someTemplate(new QName[0])).transformWith(ValueFunctions.lowercase).occurs(Ranges.once).attributes(new Attribute[]{this.someAttribute(new QName[0])})).build());
        CodelistLink.State state = (CodelistLink.State)Codes.reveal((CodelistLink)fullLinkWithoutDefaults).state();
        CodelistLinkMS clone = new CodelistLinkMS(state);
        Assert.assertEquals((Object)state.name(), (Object)clone.name());
        Assert.assertEquals((Object)state.target().id(), (Object)clone.target().id());
        Assert.assertEquals((Object)state.valueType(), (Object)clone.valueType());
        Assert.assertEquals((Object)state.function(), (Object)clone.function());
        Assert.assertEquals((Object)state.range(), (Object)clone.range());
        for (Attribute.State attr : clone.attributes()) {
            Assert.assertTrue((boolean)clone.attributes().contains(attr.name()));
        }
        Assert.assertFalse((boolean)clone.id().equals(state.id()));
        this.like(new CodelistLink.Private((CodelistLink.State)clone));
    }

    @Test
    public void linksCanChangeName() {
        CodelistLink link = (CodelistLink)this.like(((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name(Fixture.name)).target((Object)this.someCodelist(new QName[0]))).build());
        CodelistLink changeset = (CodelistLink)((CodelistLinkGrammar.OptionalClause)Codes.modifyListLink((String)link.id()).name(Fixture.name2)).build();
        Codes.reveal((CodelistLink)link).update(Codes.reveal((CodelistLink)changeset));
        Assert.assertEquals((Object)Fixture.name2, (Object)link.name());
    }

    @Test
    public void linksCanChangeValueType() {
        CodelistLink link = (CodelistLink)this.like(((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name(Fixture.name)).target((Object)this.someCodelist(new QName[0]))).build());
        Attribute template = this.someTemplate(new QName[0]);
        CodelistLink changeset = (CodelistLink)Codes.modifyListLink((String)link.id()).anchorTo(template).build();
        Codes.reveal((CodelistLink)link).update(Codes.reveal((CodelistLink)changeset));
        Assert.assertEquals((Object)new AttributeLink(new AttributeTemplate(template)), (Object)link.valueType());
    }

    @Test
    public void linksCanChangeValueTypeBackToDefault() {
        CodelistLink linktemplate = (CodelistLink)this.like(((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name(Fixture.name)).target((Object)this.someCodelist(new QName[0]))).build());
        CodelistLink link = (CodelistLink)this.like(((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name(Fixture.name)).target((Object)this.someCodelist(new QName[0]))).anchorTo(linktemplate).build());
        CodelistLink changeset = (CodelistLink)Codes.modifyListLink((String)link.id()).anchorToName().build();
        Codes.reveal((CodelistLink)link).update(Codes.reveal((CodelistLink)changeset));
        Assert.assertEquals((Object)NameLink.INSTANCE, (Object)link.valueType());
    }

    @Test
    public void linksCanChangeRange() {
        CodelistLink link = (CodelistLink)this.like(((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name(Fixture.name)).target((Object)this.someCodelist(new QName[0]))).build());
        CodelistLink changeset = (CodelistLink)Codes.modifyListLink((String)link.id()).occurs(Ranges.once).build();
        Codes.reveal((CodelistLink)link).update(Codes.reveal((CodelistLink)changeset));
        Assert.assertEquals((Object)Ranges.once, (Object)link.range());
    }

    @Test
    public void linksCanChangeFunction() {
        CodelistLink link = (CodelistLink)this.like(((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name(Fixture.name)).target((Object)this.someCodelist(new QName[0]))).build());
        CodelistLink changeset = (CodelistLink)Codes.modifyListLink((String)link.id()).transformWith((ValueFunction)ValueFunctions.custom((String)"'Hello $value'")).build();
        Codes.reveal((CodelistLink)link).update(Codes.reveal((CodelistLink)changeset));
        Assert.assertEquals((Object)ValueFunctions.custom((String)"'Hello $value'"), (Object)link.function());
    }

    private Codelist someCodelist(QName ... n) {
        return (Codelist)this.like(((CodelistGrammar.SecondClause)Codes.codelist().name(n.length > 0 ? n[0] : Fixture.name)).build());
    }

    private Attribute someAttribute(QName ... n) {
        return (Attribute)this.like(((AttributeGrammar.OptionalClause)Codes.attribute().name(n.length > 0 ? n[0] : Fixture.name)).ofType(Codes.q((String)"that")).in("this").build());
    }

    private Attribute someTemplate(QName ... n) {
        return (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name(n.length > 0 ? n[0] : Fixture.name)).ofType(Codes.q((String)"that")).in("this").build();
    }
}

