/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import org.acme.DomainTest;
import org.acme.codelists.Fixture;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.Definition;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.codelist.CodelistLink;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.dsl.grammar.CodeGrammar;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.domain.dsl.grammar.CodelistLinkGrammar;
import org.cotrix.domain.dsl.grammar.CommonClauses;
import org.cotrix.domain.dsl.grammar.DefinitionGrammar;
import org.cotrix.domain.memory.CodelistMS;
import org.cotrix.domain.utils.Constants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CodelistTest
extends DomainTest {
    Attribute attr = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name(Fixture.name)).build();
    Definition def = (Definition)((DefinitionGrammar.OptionalClause)Codes.definition().name(Fixture.name)).build();
    Code code = (Code)((CodeGrammar.OptionalClause)Codes.code().name(Fixture.name)).build();
    Codelist target = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name(Fixture.name)).build();
    CodelistLink link = (CodelistLink)((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name(Fixture.name)).target((Object)this.target)).build();
    String version = "0.1";
    Codelist list = (Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name(Fixture.name)).definitions(new Definition[]{this.def}).attributes(new Attribute[]{this.attr})).with((Object[])new Code[]{this.code})).links((Object[])new CodelistLink[]{this.link})).version(this.version).build();

    @Before
    public void stage() {
        this.target = this.like(this.target);
        this.list = this.like(this.list);
    }

    @Test
    public void codelistCanBeFluentlyConstructed() {
        Codelist minimal = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name(Fixture.name)).build();
        Assert.assertNotNull((Object)minimal.version());
        Assert.assertNotNull((Object)minimal.definitions());
        Assert.assertNotNull((Object)minimal.attributes());
        Assert.assertNotNull((Object)minimal.links());
        Assert.assertNotNull((Object)minimal.codes());
        Assert.assertTrue((boolean)this.list.attributes().contains((Object)this.attr));
        Assert.assertTrue((boolean)this.list.codes().contains((Object)this.code));
        Assert.assertTrue((boolean)this.list.links().contains((Object)this.link));
        Assert.assertTrue((boolean)this.list.definitions().contains((Object)this.def));
        Assert.assertEquals((Object)this.version, (Object)this.list.version());
    }

    @Test
    public void changesetCanBeFluentlyConstructed() {
        Codes.modify((Codelist)this.list).definitions(new Definition[]{this.def}).build();
        ((CodelistGrammar.SecondClause)Codes.modify((Codelist)this.list).attributes(new Attribute[]{this.attr})).build();
        ((CodelistGrammar.SecondClause)Codes.modify((Codelist)this.list).with((Object[])new Code[]{this.code})).build();
        ((CodelistGrammar.SecondClause)Codes.modify((Codelist)this.list).links((Object[])new CodelistLink[]{this.link})).build();
    }

    @Test
    public void canBeCloned() {
        Codelist.State state = (Codelist.State)Codes.reveal((Codelist)this.list).state();
        new CodelistMS(state);
    }

    @Test
    public void canBeVersioned() {
        Codelist versioned = (Codelist)Codes.reveal((Codelist)this.list).bump("2");
        Assert.assertEquals((Object)"2", (Object)versioned.version());
        Assert.assertEquals((Object)((Attribute)versioned.attributes().lookup(Constants.PREVIOUS_VERSION_NAME)).value(), (Object)this.list.name().toString());
        Assert.assertEquals((Object)((Attribute)versioned.attributes().lookup(Constants.PREVIOUS_VERSION_ID)).value(), (Object)this.list.id());
        Assert.assertEquals((Object)((Attribute)versioned.attributes().lookup(Constants.PREVIOUS_VERSION)).value(), (Object)this.list.version());
        Assert.assertEquals((Object)((Attribute)((Code)versioned.codes().lookup(this.code.name())).attributes().lookup(Constants.PREVIOUS_VERSION_ID)).value(), (Object)this.code.id());
        Assert.assertEquals((Object)((Attribute)((Code)versioned.codes().lookup(this.code.name())).attributes().lookup(Constants.PREVIOUS_VERSION_NAME)).value(), (Object)this.code.name().toString());
    }

    @Test(expected=IllegalStateException.class)
    public void versionsMustBeConsistent() {
        Codelist list = (Codelist)this.like(((CodelistGrammar.SecondClause)Codes.codelist().name(Fixture.name)).version("2").build());
        Codes.reveal((Codelist)list).bump("1.3");
    }

    @Test
    public void canBeUpdated() {
        Definition newdef = (Definition)((DefinitionGrammar.OptionalClause)Codes.modify((Definition)this.def).name("newname")).build();
        CodelistLink newlink = (CodelistLink)((CodelistLinkGrammar.OptionalClause)Codes.modify((CodelistLink)this.link).name("newname")).build();
        Codelist changeset = (Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.modify((Codelist)this.list).name(Fixture.name2)).definitions(new Definition[]{newdef}).attributes(new Attribute[]{Codes.delete((Attribute)this.attr)})).with((Object[])new Code[]{Codes.delete((Code)this.code)})).links((Object[])new CodelistLink[]{newlink})).build();
        Codes.reveal((Codelist)this.list).update(Codes.reveal((Codelist)changeset));
        Assert.assertEquals((Object)changeset.name(), (Object)this.list.name());
        Assert.assertTrue((boolean)this.list.definitions().contains(newdef.name()));
        Assert.assertFalse((boolean)this.list.attributes().contains(this.attr.name()));
        Assert.assertTrue((boolean)this.list.links().contains(newlink.name()));
        Assert.assertFalse((boolean)this.list.codes().contains(this.code.name()));
    }
}

