/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import org.acme.DomainTest;
import org.acme.codelists.Fixture;
import org.cotrix.domain.attributes.Definition;
import org.cotrix.domain.common.Ranges;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.grammar.DefinitionGrammar;
import org.cotrix.domain.memory.DefinitionMS;
import org.cotrix.domain.trait.Status;
import org.cotrix.domain.utils.Constants;
import org.cotrix.domain.validation.Constraint;
import org.cotrix.domain.validation.Validators;
import org.cotrix.domain.values.DefaultType;
import org.cotrix.domain.values.ValueType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefinitionTest
extends DomainTest {
    ValueType vtype = Codes.valueType().with(new Constraint[]{Validators.max_length.instance(new Object[]{"20"})});
    Definition def = (Definition)((DefinitionGrammar.OptionalClause)Codes.definition().name(Fixture.name)).is(Fixture.type).valueIs(this.vtype).in(Fixture.language).occurs(Ranges.once).build();

    @Before
    public void before() {
        this.def = this.like(this.def);
    }

    @Test
    public void canBeFluentlyConstructed() {
        Definition minimal = (Definition)((DefinitionGrammar.OptionalClause)Codes.definition().name(Fixture.name)).build();
        Assert.assertEquals((Object)Constants.DEFAULT_TYPE, (Object)minimal.type());
        Assert.assertEquals((Object)Constants.defaultValueType, (Object)minimal.valueType());
        Assert.assertEquals((Object)Ranges.arbitrarily, (Object)minimal.range());
        Assert.assertNull((Object)minimal.language());
        Assert.assertEquals((Object)Fixture.name, (Object)this.def.name());
        Assert.assertEquals((Object)Fixture.type, (Object)this.def.type());
        Assert.assertEquals((Object)Fixture.language, (Object)this.def.language());
        Assert.assertEquals((Object)Codes.valueType().with(new Constraint[]{Validators.max_length.instance(new Object[]{"20"})}), (Object)this.def.valueType());
        Assert.assertEquals((Object)Ranges.once, (Object)this.def.range());
    }

    @Test
    public void changesetsCanBeFluentlyConstructed() {
        Definition a = (Definition)((DefinitionGrammar.OptionalClause)Codes.modify((Definition)this.def).name(Fixture.name)).build();
        a = (Definition)Codes.modify((Definition)this.def).is(Fixture.type).build();
        a = (Definition)Codes.modify((Definition)this.def).in(Fixture.language).build();
        a = (Definition)Codes.modify((Definition)this.def).valueIs(Constants.defaultValueType).build();
        a = (Definition)Codes.modify((Definition)this.def).occurs(Ranges.once).build();
        Assert.assertTrue((boolean)Codes.reveal((Definition)a).isChangeset());
        Assert.assertEquals((Object)Status.MODIFIED, (Object)Codes.reveal((Definition)a).status());
    }

    @Test
    public void canBeCloned() {
        Definition.State state = (Definition.State)Codes.reveal((Definition)this.def).state();
        DefinitionMS clone = new DefinitionMS(state);
        Assert.assertEquals((Object)clone, (Object)state);
    }

    @Test
    public void canBeUpdated() {
        DefaultType vtype2 = Codes.valueType().with(new Constraint[]{Validators.max_length.instance(new Object[]{"10"})});
        Definition changeset = (Definition)((DefinitionGrammar.OptionalClause)Codes.modify((Definition)this.def).name(Fixture.name2)).is(Fixture.type2).valueIs((ValueType)vtype2).in(Fixture.language2).occurs(Ranges.arbitrarily).build();
        Codes.reveal((Definition)this.def).update(Codes.reveal((Definition)changeset));
        Assert.assertEquals((Object)changeset, (Object)this.def);
    }

    @Test(expected=IllegalArgumentException.class)
    public void cannotErasetName() {
        Definition changeset = (Definition)((DefinitionGrammar.OptionalClause)Codes.modify((Definition)this.def).name(Constants.NULL_QNAME)).build();
        Codes.reveal((Definition)this.def).update(Codes.reveal((Definition)changeset));
    }

    @Test(expected=IllegalArgumentException.class)
    public void cannotEraseType() {
        Definition changeset = (Definition)Codes.modify((Definition)this.def).is(Constants.NULL_QNAME).build();
        Codes.reveal((Definition)this.def).update(Codes.reveal((Definition)changeset));
    }

    @Test
    public void canEraseLanguage() {
        Definition changeset = (Definition)Codes.modify((Definition)this.def).in("__ignore__").build();
        Codes.reveal((Definition)this.def).update(Codes.reveal((Definition)changeset));
        Assert.assertNull((Object)this.def.language());
    }
}

