/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import org.acme.DomainTest;
import org.acme.codelists.Fixture;
import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.common.Ranges;
import org.cotrix.domain.common.Status;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.dsl.grammar.AttributeDefinitionGrammar;
import org.cotrix.domain.memory.MAttrDef;
import org.cotrix.domain.utils.DomainConstants;
import org.cotrix.domain.validation.Constraint;
import org.cotrix.domain.validation.Validators;
import org.cotrix.domain.values.DefaultType;
import org.cotrix.domain.values.ValueType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AttrDefTest
extends DomainTest {
    ValueType vtype = Data.valueType().with(new Constraint[]{Validators.max_length.instance(new Object[]{"20"})});
    AttributeDefinition def = (AttributeDefinition)((AttributeDefinitionGrammar.SecondClause)Data.attrdef().name(Fixture.name)).is(Fixture.type).valueIs(this.vtype).in(Fixture.language).occurs(Ranges.once).build();

    @Before
    public void before() {
        this.def = this.like(this.def);
    }

    @Test
    public void canBeFluentlyConstructed() {
        AttributeDefinition minimal = (AttributeDefinition)((AttributeDefinitionGrammar.SecondClause)Data.attrdef().name(Fixture.name)).build();
        Assert.assertEquals((Object)DomainConstants.defaultType, (Object)minimal.type());
        Assert.assertEquals((Object)DomainConstants.defaultValueType, (Object)minimal.valueType());
        Assert.assertEquals((Object)DomainConstants.defaultRange, (Object)minimal.range());
        Assert.assertNull((Object)minimal.language());
        Assert.assertEquals((Object)Fixture.name, (Object)this.def.qname());
        Assert.assertEquals((Object)Fixture.type, (Object)this.def.type());
        Assert.assertEquals((Object)Fixture.language, (Object)this.def.language());
        Assert.assertEquals((Object)Data.valueType().with(new Constraint[]{Validators.max_length.instance(new Object[]{"20"})}), (Object)this.def.valueType());
        Assert.assertEquals((Object)Ranges.once, (Object)this.def.range());
    }

    @Test
    public void changesetsCanBeFluentlyConstructed() {
        AttributeDefinition a = (AttributeDefinition)((AttributeDefinitionGrammar.SecondClause)Data.modify((AttributeDefinition)this.def).name(Fixture.name)).build();
        a = (AttributeDefinition)Data.modify((AttributeDefinition)this.def).is(Fixture.type).build();
        a = (AttributeDefinition)Data.modify((AttributeDefinition)this.def).in(Fixture.language).build();
        a = (AttributeDefinition)Data.modify((AttributeDefinition)this.def).valueIs(DomainConstants.defaultValueType).build();
        a = (AttributeDefinition)Data.modify((AttributeDefinition)this.def).occurs(Ranges.once).build();
        Assert.assertTrue((boolean)Data.reveal((AttributeDefinition)a).isChangeset());
        Assert.assertEquals((Object)Status.MODIFIED, (Object)Data.reveal((AttributeDefinition)a).status());
    }

    @Test
    public void canBeCloned() {
        AttributeDefinition.Bean bean = (AttributeDefinition.Bean)Data.reveal((AttributeDefinition)this.def).bean();
        MAttrDef clone = new MAttrDef(bean);
        Assert.assertEquals((Object)clone, (Object)bean);
    }

    @Test
    public void canBeUpdated() {
        DefaultType vtype2 = Data.valueType().with(new Constraint[]{Validators.max_length.instance(new Object[]{"10"})});
        AttributeDefinition changeset = (AttributeDefinition)((AttributeDefinitionGrammar.SecondClause)Data.modify((AttributeDefinition)this.def).name(Fixture.name2)).is(Fixture.type2).valueIs((ValueType)vtype2).in(Fixture.language2).occurs(DomainConstants.defaultRange).build();
        Data.reveal((AttributeDefinition)this.def).update(Data.reveal((AttributeDefinition)changeset));
        Assert.assertEquals((Object)changeset, (Object)this.def);
    }

    @Test(expected=IllegalArgumentException.class)
    public void cannotErasetName() {
        AttributeDefinition changeset = (AttributeDefinition)((AttributeDefinitionGrammar.SecondClause)Data.modify((AttributeDefinition)this.def).name(DomainConstants.NULL_QNAME)).build();
        Data.reveal((AttributeDefinition)this.def).update(Data.reveal((AttributeDefinition)changeset));
    }

    @Test(expected=IllegalArgumentException.class)
    public void cannotEraseType() {
        AttributeDefinition changeset = (AttributeDefinition)Data.modify((AttributeDefinition)this.def).is(DomainConstants.NULL_QNAME).build();
        Data.reveal((AttributeDefinition)this.def).update(Data.reveal((AttributeDefinition)changeset));
    }

    @Test
    public void canEraseLanguage() {
        AttributeDefinition changeset = (AttributeDefinition)Data.modify((AttributeDefinition)this.def).in("__ignore__").build();
        Data.reveal((AttributeDefinition)this.def).update(Data.reveal((AttributeDefinition)changeset));
        Assert.assertNull((Object)this.def.language());
    }
}

