/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import java.util.HashMap;
import org.acme.DomainTest;
import org.acme.codelists.Fixture;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.dsl.grammar.AttributeDefinitionGrammar;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.memory.MAttrDef;
import org.cotrix.domain.memory.MAttribute;
import org.cotrix.domain.utils.DomainConstants;
import org.cotrix.domain.utils.DomainUtils;
import org.cotrix.domain.validation.Constraint;
import org.cotrix.domain.validation.Validators;
import org.cotrix.domain.values.DefaultType;
import org.cotrix.domain.values.ValueType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class AttributeTest
extends DomainTest {
    Attribute untyped = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(Fixture.name)).ofType(Fixture.type).value(Fixture.value).in(Fixture.language).description(Fixture.description).build();
    ValueType valuetype = Data.valueType().defaultsTo("mydef");
    AttributeDefinition def = (AttributeDefinition)((AttributeDefinitionGrammar.SecondClause)Data.attrdef().name(Fixture.name)).build();
    Attribute typed = (Attribute)Data.attribute().instanceOf(this.def).value(Fixture.value).build();
    Attribute typed2 = (Attribute)Data.attribute().instanceOf(this.def).value(Fixture.value2).build();

    @Before
    public void before() {
        this.untyped = this.like(this.untyped);
        this.typed = this.like(this.typed);
        this.typed2 = this.like(this.typed2);
    }

    @Test
    public void attributesCanBeFluentlyConstructed() {
        Attribute minimalUntyped = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(Fixture.name)).build();
        Assert.assertNotNull((Object)minimalUntyped.definition());
        Assert.assertNull((Object)minimalUntyped.value());
        Assert.assertNull((Object)minimalUntyped.note());
        Assert.assertEquals((Object)((AttributeDefinition)this.untyped.definition()).qname(), (Object)this.untyped.qname());
        Assert.assertEquals((Object)((AttributeDefinition)this.untyped.definition()).type(), (Object)this.untyped.type());
        Assert.assertEquals((Object)((AttributeDefinition)this.untyped.definition()).language(), (Object)this.untyped.language());
        AttributeDefinition def = (AttributeDefinition)((AttributeDefinitionGrammar.SecondClause)Data.attrdef().name(Fixture.name)).valueIs(this.valuetype).build();
        Attribute minimalTyped = (Attribute)Data.attribute().instanceOf(def).build();
        Assert.assertEquals((Object)def, (Object)minimalTyped.definition());
        Assert.assertEquals((Object)this.valuetype.defaultValue(), (Object)minimalTyped.value());
    }

    @Test
    public void changesetsCanBeFluentlyConstructed() {
        ((AttributeGrammar.FourthClause)Data.modify((Attribute)this.untyped).name(Fixture.name)).build();
        Data.modify((Attribute)this.untyped).value(Fixture.value).build();
        Data.modify((Attribute)this.untyped).ofType(Fixture.type).build();
        Data.modify((Attribute)this.untyped).in(Fixture.language).build();
        Data.modify((Attribute)this.untyped).description(Fixture.description).build();
        AttributeDefinition newdef = (AttributeDefinition)((AttributeDefinitionGrammar.SecondClause)Data.attrdef().name(Fixture.name)).build();
        Data.modify((Attribute)this.typed).instanceOf(newdef).build();
        Data.modifyAttribute((String)"1").instanceOf(newdef).value(Fixture.value).build();
    }

    @Test
    public void canBeCloned() {
        Attribute.Bean bean = (Attribute.Bean)Data.reveal((Attribute)this.untyped).bean();
        MAttribute clone = new MAttribute(bean);
        Assert.assertEquals((Object)clone, (Object)bean);
        Assert.assertEquals((Object)bean.id(), (Object)clone.id());
        Assert.assertNotEquals((Object)((AttributeDefinition.Bean)bean.definition()).id(), (Object)clone.definition().id());
    }

    @Test
    public void cloningCanPreserveSharing() {
        HashMap<String, MAttrDef> ctx = new HashMap<String, MAttrDef>();
        ctx.put(((AttributeDefinition)this.typed.definition()).id(), new MAttrDef(DomainUtils.beanOf((AttributeDefinition)((AttributeDefinition)this.typed.definition()))));
        MAttribute clone1 = new MAttribute(DomainUtils.beanOf((Attribute)this.typed), ctx);
        MAttribute clone2 = new MAttribute(DomainUtils.beanOf((Attribute)this.typed2), ctx);
        Assert.assertSame((Object)clone1.definition(), (Object)clone2.definition());
    }

    @Test
    public void canBeUpdated() {
        Attribute changesetUntyped = (Attribute)((AttributeGrammar.FourthClause)Data.modify((Attribute)this.untyped).name(Fixture.newname)).value(Fixture.newvalue).ofType(Fixture.newtype).in(Fixture.newlanguage).description(Fixture.newdescription).build();
        Data.reveal((Attribute)this.untyped).update(Data.reveal((Attribute)changesetUntyped));
        Assert.assertEquals((Object)changesetUntyped.qname(), (Object)this.untyped.qname());
        Assert.assertEquals((Object)changesetUntyped.value(), (Object)this.untyped.value());
        Assert.assertEquals((Object)changesetUntyped.type(), (Object)this.untyped.type());
        Assert.assertEquals((Object)changesetUntyped.language(), (Object)this.untyped.language());
        Assert.assertEquals((Object)changesetUntyped.note(), (Object)this.untyped.note());
        AttributeDefinition newdef = (AttributeDefinition)((AttributeDefinitionGrammar.SecondClause)Data.attrdef().name(Fixture.name2)).build();
        Attribute changesetTyped = (Attribute)Data.modify((Attribute)this.typed).instanceOf(newdef).value(Fixture.value2).build();
        Data.reveal((Attribute)this.typed).update(Data.reveal((Attribute)changesetTyped));
        Assert.assertEquals((Object)changesetTyped.definition(), (Object)this.typed.definition());
        Assert.assertEquals((Object)changesetTyped.value(), (Object)this.typed.value());
    }

    @Test(expected=IllegalArgumentException.class)
    public void cannotErasetName() {
        Attribute changeset = (Attribute)((AttributeGrammar.FourthClause)Data.modify((Attribute)this.untyped).name(DomainConstants.NULL_QNAME)).build();
        Data.reveal((Attribute)this.untyped).update(Data.reveal((Attribute)changeset));
    }

    @Test
    public void canEraseValue() {
        Attribute changeset = (Attribute)Data.modify((Attribute)this.typed).value("__ignore__").build();
        Data.reveal((Attribute)this.typed).update(Data.reveal((Attribute)changeset));
        Assert.assertNull((Object)this.typed.value());
    }

    @Test
    public void canEraseDescription() {
        Attribute changeset = (Attribute)Data.modify((Attribute)this.typed).description("__ignore__").build();
        Data.reveal((Attribute)this.typed).update(Data.reveal((Attribute)changeset));
        Assert.assertNull((Object)this.typed.note());
    }

    @Test(expected=IllegalArgumentException.class)
    public void canEraseType() {
        Attribute changeset = (Attribute)Data.modify((Attribute)this.untyped).ofType(DomainConstants.NULL_QNAME).build();
        Data.reveal((Attribute)this.untyped).update(Data.reveal((Attribute)changeset));
    }

    @Test
    public void canEraseLanguage() {
        Attribute changeset = (Attribute)Data.modify((Attribute)this.untyped).in("__ignore__").build();
        Data.reveal((Attribute)this.untyped).update(Data.reveal((Attribute)changeset));
        Assert.assertNull((Object)this.untyped.language());
    }

    @Ignore
    @Test(expected=IllegalArgumentException.class)
    public void cannoteViolateConstraints() {
        DefaultType newtype = Data.valueType().with(new Constraint[]{Validators.max_length.instance(new Object[]{2})});
        AttributeDefinition defChangeset = (AttributeDefinition)Data.modify((AttributeDefinition)((AttributeDefinition)this.typed.definition())).valueIs((ValueType)newtype).build();
        Data.reveal((AttributeDefinition)((AttributeDefinition)this.typed.definition())).update(Data.reveal((AttributeDefinition)defChangeset));
        Attribute changeset = (Attribute)Data.modify((Attribute)this.typed).value("12").build();
        Data.reveal((Attribute)this.typed).update(Data.reveal((Attribute)changeset));
        changeset = (Attribute)Data.modify((Attribute)this.typed).value("123").build();
        Data.reveal((Attribute)this.typed).update(Data.reveal((Attribute)changeset));
    }
}

