/*
 * Decompiled with CFR 0.152.
 */
package org.acme.validation;

import org.cotrix.common.script.JavascriptEngine;
import org.cotrix.common.script.ScriptEngine;
import org.cotrix.domain.validation.Constraint;
import org.cotrix.domain.validation.Validators;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ValidatorTest {
    ScriptEngine engine = new JavascriptEngine();

    @BeforeClass
    public static void setup() {
        System.setProperty("org.slf4j.simpleLogger.log.org.cotrix", "trace");
    }

    @Test
    public void maxlength() {
        Constraint v = Validators.max_length.instance(new Object[]{"2"});
        boolean outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("123"));
        Assert.assertFalse((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("12"));
        Assert.assertTrue((boolean)outcome);
    }

    @Test
    public void minlength() {
        Constraint v = Validators.min_length.instance(new Object[]{"2"});
        boolean outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("1"));
        Assert.assertFalse((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("12"));
        Assert.assertTrue((boolean)outcome);
    }

    @Test
    public void regexp() {
        Constraint v = Validators.regexp.instance(new Object[]{"hel.o"});
        boolean outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("helo"));
        Assert.assertFalse((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("hello"));
        Assert.assertTrue((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("helllo"));
        Assert.assertFalse((boolean)outcome);
    }

    @Test
    public void isNumber() {
        Constraint v = Validators.number.instance(new Object[0]);
        boolean outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("hello"));
        Assert.assertFalse((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("12"));
        Assert.assertTrue((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("-14.56"));
        Assert.assertTrue((boolean)outcome);
    }

    @Test
    public void atLeast() {
        Constraint v = Validators.atleast.instance(new Object[]{10});
        boolean outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("9"));
        Assert.assertFalse((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("10"));
        Assert.assertTrue((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("11.3"));
        Assert.assertTrue((boolean)outcome);
    }

    @Test
    public void greater() {
        Constraint v = Validators.greater.instance(new Object[]{10});
        boolean outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("10"));
        Assert.assertFalse((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("11"));
        Assert.assertTrue((boolean)outcome);
    }

    @Test
    public void atMost() {
        Constraint v = Validators.atmost.instance(new Object[]{10});
        boolean outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("11"));
        Assert.assertFalse((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("9"));
        Assert.assertTrue((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("7.5"));
        Assert.assertTrue((boolean)outcome);
    }

    @Test
    public void smaller() {
        Constraint v = Validators.smaller.instance(new Object[]{10});
        boolean outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("10"));
        Assert.assertFalse((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("9"));
        Assert.assertTrue((boolean)outcome);
    }

    @Test
    public void between() {
        Constraint v = Validators.between.instance(new Object[]{10, 15});
        boolean outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("9"));
        Assert.assertFalse((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("11"));
        Assert.assertTrue((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("15"));
        Assert.assertTrue((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("16"));
        Assert.assertFalse((boolean)outcome);
    }

    @Test
    public void date() {
        Constraint v = Validators.date.instance(new Object[0]);
        boolean outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("dfdsfds"));
        Assert.assertFalse((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("10 Oct 2009"));
        Assert.assertTrue((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("Oct 10 2009"));
        Assert.assertTrue((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("10/10/2009"));
        Assert.assertTrue((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("2009 October 10"));
        Assert.assertTrue((boolean)outcome);
    }

    @Test
    public void before() {
        Constraint v = Validators.before.instance(new Object[]{"10 Oct 2009"});
        boolean outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("dfdsfds"));
        Assert.assertFalse((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("10 Oct 2009"));
        Assert.assertFalse((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("Oct 11 2009"));
        Assert.assertFalse((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("9 Oct 2009"));
        Assert.assertTrue((boolean)outcome);
    }

    @Test
    public void after() {
        Constraint v = Validators.after.instance(new Object[]{"10 Oct 2009"});
        boolean outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("dfdsfds"));
        Assert.assertFalse((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("10 Oct 2009"));
        Assert.assertFalse((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("Oct 9 2009"));
        Assert.assertFalse((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("11 Oct 2009"));
        Assert.assertTrue((boolean)outcome);
    }

    @Test
    public void betweenDates() {
        Constraint v = Validators.between_dates.instance(new Object[]{"10 Oct 2009", "12 Oct 2009"});
        boolean outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("dfdsfds"));
        Assert.assertFalse((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("10 Oct 2009"));
        Assert.assertFalse((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("Oct 12 2009"));
        Assert.assertFalse((boolean)outcome);
        outcome = Boolean.valueOf(this.engine.eval(v.expression()).with("11 Oct 2009"));
        Assert.assertTrue((boolean)outcome);
    }

    @Test
    public void custom() {
        Constraint v = Validators.custom.instance(new Object[]{"true"});
        boolean outcome = Boolean.valueOf(this.engine.eval(v.expression()).withNothing());
        Assert.assertTrue((boolean)outcome);
    }
}

