/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import java.util.HashMap;
import org.acme.DomainTest;
import org.acme.codelists.Fixture;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.dsl.grammar.AttributeDefinitionGrammar;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.dsl.grammar.CodeGrammar;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.domain.dsl.grammar.LinkDefinitionGrammar;
import org.cotrix.domain.links.Link;
import org.cotrix.domain.links.LinkDefinition;
import org.cotrix.domain.memory.MAttrDef;
import org.cotrix.domain.memory.MCode;
import org.cotrix.domain.memory.MLinkDef;
import org.cotrix.domain.trait.Named;
import org.cotrix.domain.utils.DomainUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CodeTest
extends DomainTest {
    Attribute attr = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(Fixture.name)).build();
    AttributeDefinition def = (AttributeDefinition)((AttributeDefinitionGrammar.SecondClause)Data.attrdef().name(Fixture.name2)).build();
    Attribute a1 = (Attribute)Data.attribute().instanceOf(this.def).value("val1").build();
    Attribute a2 = (Attribute)Data.attribute().instanceOf(this.def).value("val2").build();
    Code targetcode = (Code)((CodeGrammar.SecondClause)Data.code().name(Fixture.name2)).build();
    Codelist target = (Codelist)((CodelistGrammar.SecondClause)Data.codelist().name(Fixture.name)).with(new Code[]{this.targetcode}).build();
    LinkDefinition linkdef = (LinkDefinition)((LinkDefinitionGrammar.SecondClause)Data.linkdef().name(Fixture.name)).target(this.target).build();
    Link link = (Link)Data.link().instanceOf(this.linkdef).target(this.targetcode).build();
    Code code = (Code)((CodeGrammar.SecondClause)((CodeGrammar.SecondClause)Data.code().name(Fixture.name)).attributes(new Attribute[]{this.attr, this.a1, this.a2})).links(new Link[]{this.link}).build();

    @Before
    public void stage() {
        this.target = this.like(this.target);
        this.def = this.like(this.def);
        this.linkdef = this.like(this.linkdef);
        this.code = this.like(this.code);
    }

    @Test
    public void codesCanBeFluentlyConstructed() {
        Code minimal = (Code)((CodeGrammar.SecondClause)Data.code().name(Fixture.name)).build();
        Assert.assertNotNull((Object)minimal.attributes());
        Assert.assertNotNull((Object)minimal.links());
        Assert.assertTrue((boolean)this.code.attributes().contains((Named)this.attr));
        Assert.assertTrue((boolean)this.code.links().contains((Named)this.link));
        Assert.assertTrue((boolean)this.code.attributes().contains((Named)this.attr));
        Assert.assertTrue((boolean)((AttributeDefinition)this.a1.definition()).isShared());
        Assert.assertFalse((boolean)((AttributeDefinition)this.attr.definition()).isShared());
    }

    @Test
    public void changesetsCanBeFluentlyConstructed() {
        ((CodeGrammar.SecondClause)Data.modify((Code)this.code).name(Fixture.name)).build();
        ((CodeGrammar.SecondClause)Data.modify((Code)this.code).attributes(new Attribute[]{this.attr})).build();
        Data.modify((Code)this.code).links(new Link[]{this.link}).build();
        Data.delete((Code)this.code);
    }

    @Test
    public void canBeCloned() {
        Code.Bean bean = DomainUtils.beanOf((Code)this.code);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(this.def.id(), new MAttrDef(DomainUtils.beanOf((AttributeDefinition)this.def)));
        context.put(this.linkdef.id(), new MLinkDef(DomainUtils.beanOf((LinkDefinition)this.linkdef)));
        MCode clone = new MCode(bean, context);
        Assert.assertEquals((Object)bean.qname(), (Object)clone.qname());
        Assert.assertTrue((boolean)clone.attributes().contains(this.attr.qname()));
        Assert.assertTrue((boolean)clone.links().contains(this.link.qname()));
    }

    @Test
    public void canBeUpdated() {
        Code changeset = (Code)((CodeGrammar.SecondClause)((CodeGrammar.SecondClause)Data.modify((Code)this.code).name(Fixture.name2)).attributes(new Attribute[]{Data.delete((Attribute)this.attr)})).links(new Link[]{Data.delete((Link)this.link)}).build();
        Data.reveal((Code)this.code).update(Data.reveal((Code)changeset));
        Assert.assertEquals((Object)changeset.qname(), (Object)this.code.qname());
        Assert.assertFalse((boolean)this.code.attributes().contains((Named)this.attr));
        Assert.assertFalse((boolean)this.code.links().contains((Named)this.link));
    }
}

