package org.cotrix.web.manage.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;

public interface ManageServiceAsync
{

    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.manage.client.ManageService
     */
    void getCodelistCodes( java.lang.String codelistId, com.google.gwt.view.client.Range range, org.cotrix.web.manage.shared.CodelistEditorSortInfo sortInfo, AsyncCallback<org.cotrix.web.common.shared.DataWindow<org.cotrix.web.common.shared.codelist.UICode>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.manage.client.ManageService
     */
    void getAttributesGroups( java.lang.String codelistId, AsyncCallback<java.util.Set<org.cotrix.web.manage.shared.Group>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.manage.client.ManageService
     */
    void getCodelistsGrouped( AsyncCallback<org.cotrix.web.common.shared.DataWindow<org.cotrix.web.manage.shared.CodelistGroup>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.manage.client.ManageService
     */
    void getMetadata( java.lang.String codelistId, AsyncCallback<org.cotrix.web.common.shared.codelist.UICodelistMetadata> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.manage.client.ManageService
     */
    void createNewCodelistVersion( java.lang.String codelistId, java.lang.String newVersion, AsyncCallback<org.cotrix.web.manage.shared.CodelistGroup> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.manage.client.ManageService
     */
    void removeCodelist( java.lang.String codelistId, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.manage.client.ManageService
     */
    void getCodelistState( java.lang.String codelistId, AsyncCallback<org.cotrix.web.common.shared.feature.ResponseWrapper<java.lang.String>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.manage.client.ManageService
     */
    void lock( java.lang.String codelistId, AsyncCallback<org.cotrix.web.common.shared.feature.FeatureCarrier.Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.manage.client.ManageService
     */
    void unlock( java.lang.String codelistId, AsyncCallback<org.cotrix.web.common.shared.feature.FeatureCarrier.Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.manage.client.ManageService
     */
    void seal( java.lang.String codelistId, AsyncCallback<org.cotrix.web.common.shared.feature.FeatureCarrier.Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.manage.client.ManageService
     */
    void modify( java.lang.String codelistId, org.cotrix.web.manage.shared.modify.ModifyCommand command, AsyncCallback<org.cotrix.web.manage.shared.modify.ModifyCommandResult> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.manage.client.ManageService
     */
    void getAttributeNames( java.lang.String codelistId, AsyncCallback<java.util.Set<org.cotrix.web.common.shared.codelist.UIQName>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.manage.client.ManageService
     */
    void createNewCodelist( java.lang.String name, java.lang.String version, AsyncCallback<org.cotrix.web.manage.shared.CodelistGroup> callback );


    /**
     * Utility class to get the RPC Async interface from client-side code
     */
    public static final class Util 
    { 
        private static ManageServiceAsync instance;

        public static final ManageServiceAsync getInstance()
        {
            if ( instance == null )
            {
                instance = (ManageServiceAsync) GWT.create( ManageService.class );
            }
            return instance;
        }

        private Util()
        {
            // Utility class should not be instanciated
        }
    }
}
