package org.cotrix.web.client.view;

import org.cotrix.web.share.client.util.AccountValidator;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author "Federico De Faveri federico.defaveri@fao.org"
 *
 */
public class RegisterDialog extends PopupPanel {
	
	
	private static final Binder binder = GWT.create(Binder.class);
	interface Binder extends UiBinder<Widget, RegisterDialog> {}
	
	public interface RegisterDialogListener {
		public void onRegister(String username, String password, String email);
		public void onCancel();
	}
	
	protected interface Style extends CssResource {
		String invalidValue();
	}
	
	@UiField
	Style style;
	
	@UiField
	TextBox username;
	
	@UiField
	PasswordTextBox password;
	
	@UiField
	TextBox email;
	
	protected RegisterDialogListener listener;

	public RegisterDialog(RegisterDialogListener listener) {
		this.listener = listener;
		setWidget(binder.createAndBindUi(this));
		setAutoHideEnabled(true);
	}
	
	@UiHandler({"username","password","email"})
	protected void onKeyDown(KeyDownEvent event)
	{
		 if(event.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
	    	 doRegister();
	     }
		 if (event.getSource() instanceof UIObject) {
			 UIObject uiObject = (UIObject)event.getSource();
			 uiObject.setStyleName(style.invalidValue(), false);
		 }
	}
	
	@UiHandler("create")
	protected void onRegister(ClickEvent clickEvent)
	{
		doRegister();
	}
	
	protected void doRegister() {
		boolean valid = validate();
		if (valid) listener.onRegister(username.getText(), password.getText(), email.getText());
	}
	
	protected boolean validate()
	{
		boolean valid = true;
		if (!AccountValidator.validateUsername(username.getText())) {
			username.setStyleName(style.invalidValue(), true);
			valid = false;
		}
		
		if (!AccountValidator.validatePassword(password.getText())) {
			password.setStyleName(style.invalidValue(), true);
			valid = false;
		}
		
		if (!AccountValidator.validateEMail(email.getText())) {
			email.setStyleName(style.invalidValue(), true);
			valid = false;
		}
		
		return valid;
	}

	/** 
	 * {@inheritDoc}
	 */
	@Override
	public void show() {
		super.show();
		Scheduler.get().scheduleDeferred(new ScheduledCommand() {

		    @Override
		    public void execute() {
		        username.setFocus(true);
		    }
		});
	}
	

	public void clean() {
		username.setText("");
		password.setText("");
		email.setText("");
	}

	
}
