/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.client.javax.filters;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Response;
import org.fao.fi.security.common.encryption.pgp.exceptions.KeyringException;
import org.fao.fi.security.common.services.spi.decryption.DecryptionService;
import org.fao.fi.security.common.support.decryption.EncryptedInputStreamWrapper;
import org.fao.fi.security.common.utilities.LoggingClient;

public class EncryptedResponseDecorator
extends LoggingClient
implements ClientResponseFilter {
    @Inject
    @Singleton
    private DecryptionService _decryptor;

    public EncryptedResponseDecorator(DecryptionService decryptor) {
        this._decryptor = decryptor;
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        try {
            responseContext.setEntityStream((InputStream)new EncryptedInputStreamWrapper(responseContext.getEntityStream(), this._decryptor));
        }
        catch (GeneralSecurityException | KeyringException se) {
            this._log.error(se.getMessage(), se);
            throw new BadRequestException("You are not authorized to access this resource", Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
        }
        catch (Throwable t) {
            throw new ServerErrorException("An unexpected server-side error occurred while attempting to access this resource", Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
        }
    }
}

