/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.client.providers.token.impl;

import java.net.URL;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.fao.fi.security.client.providers.token.spi.TokenProducerServiceClient;
import org.fao.fi.security.common.services.exceptions.token.TokenProcessingException;
import org.fao.fi.security.common.support.token.spi.TokenProcessor;
import org.fao.fi.security.common.utilities.LoggingClient;
import org.glassfish.jersey.client.ClientConfig;

public abstract class AbstractTokenProviderServiceClient
extends LoggingClient
implements TokenProducerServiceClient {
    private Client _client = null;
    private ClientConfig _config = new ClientConfig();
    private URL _endpoint;
    private TokenProcessor _tokenProcessor;

    public AbstractTokenProviderServiceClient(URL endpoint, TokenProcessor tokenProcessor) {
        this._endpoint = endpoint;
        this._tokenProcessor = tokenProcessor;
        this._client = ClientBuilder.newClient((Configuration)this._config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Invocation.Builder buildRequest() {
        long start = System.currentTimeMillis();
        this._log.info("Building token request to {}", (Object)this._endpoint);
        try {
            Invocation.Builder builder = this._client.target(this._endpoint.toString()).request().accept(new String[]{"text/plain"});
            return builder;
        }
        finally {
            long end = System.currentTimeMillis();
            this._log.info("Token request to {} has been built in {} mSec.", (Object)this._endpoint, (Object)(end - start));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String requestToken() throws TokenProcessingException {
        long start = System.currentTimeMillis();
        this._log.info("Requesting and extracting token from {}", (Object)this._endpoint);
        try {
            String string = this.extractToken(this.request());
            return string;
        }
        finally {
            long end = System.currentTimeMillis();
            this._log.info("Token has been requested and extracted from {} in {} mSec.", (Object)this._endpoint, (Object)(end - start));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response request() {
        long start = System.currentTimeMillis();
        this._log.info("Requesting token from {}", (Object)this._endpoint);
        try {
            Response response = this.buildRequest().get();
            return response;
        }
        finally {
            long end = System.currentTimeMillis();
            this._log.info("Token has been received from {} in {} mSec.", (Object)this._endpoint, (Object)(end - start));
        }
    }

    @Override
    public String extractToken(Response response) throws TokenProcessingException {
        long start = System.currentTimeMillis();
        this._log.info("Extracting token from response received by {}", (Object)this._endpoint);
        try {
            long tempStart = System.currentTimeMillis();
            if (response.getStatus() == 200) {
                this._log.info("Reading response entity...");
                String token = (String)response.readEntity(String.class);
                long tempEnd = System.currentTimeMillis();
                this._log.info("Response entity has been read in {} mSec. ({} bytes in total)", (Object)(tempEnd - tempStart), (Object)token.getBytes().length);
                this._log.info("Processing token before consumption via {}...", (Object)this._tokenProcessor.getClass().getSimpleName());
                tempStart = System.currentTimeMillis();
                token = this._tokenProcessor.processBeforeConsumption(token);
                tempEnd = System.currentTimeMillis();
                this._log.info("Processing token before consumption via {} took {} mSec.", (Object)this._tokenProcessor.getClass().getSimpleName(), (Object)(tempEnd - tempStart));
                String string = token;
                return string;
            }
            if (response.getStatus() == 404) {
                throw new NotFoundException(response);
            }
            throw new ClientErrorException(response.getStatus());
        }
        finally {
            long end = System.currentTimeMillis();
            this._log.info("Token has been extracted and processed from response received by {} in {} mSec.", (Object)this._endpoint, (Object)(end - start));
        }
    }

    public final void registerFilter(ClientRequestFilter toRegister) {
        this._client.register((Object)toRegister);
    }
}

