/**
 * (c) 2014 FAO / UN (project: fi-security-server)
 */
package org.fao.fi.security.common.support.encryption.pgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.NoSuchProviderException;

import javax.inject.Inject;

import org.bouncycastle.openpgp.PGPException;
import org.fao.fi.security.common.encryption.pgp.PGPEncryptorBean;
import org.fao.fi.security.common.encryption.pgp.exceptions.KeyringException;
import org.fao.fi.security.common.services.spi.encryption.EncryptionService;
import org.fao.fi.security.common.utilities.LoggingClient;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 2 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 2 May 2014
 */
public class PGPResponseEncryptionServiceProvider extends LoggingClient implements EncryptionService {
	private PGPEncryptorBean _encryptor;
	
	/**
	 * Class constructor
	 *
	 * @param encryptor
	 */
	@Inject public PGPResponseEncryptionServiceProvider(PGPEncryptorBean encryptor) {
		super();
		this._encryptor = encryptor;
	}

	/* (non-Javadoc)
	 * @see org.fao.fi.security.server.providers.encryptors.ResponseEncryptionServiceProvider#encrypt(java.io.InputStream, java.io.OutputStream)
	 */
	@Override
	public void encrypt(InputStream incoming, OutputStream outgoing) throws IOException, KeyringException, NoSuchProviderException, GeneralSecurityException {
		try {
			this._encryptor.encryptStream(incoming, outgoing);
		} catch(PGPException Pe) {
			throw new GeneralSecurityException(Pe);
		}
	}
}