/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.common.support.token.impl;

import javax.inject.Inject;
import org.fao.fi.security.common.encryption.pgp.PGPDecryptorBean;
import org.fao.fi.security.common.encryption.pgp.PGPEncryptorBean;
import org.fao.fi.security.common.encryption.pgp.exceptions.KeyringAccessException;
import org.fao.fi.security.common.encryption.pgp.exceptions.MissingOrBadKeyringException;
import org.fao.fi.security.common.services.exceptions.token.TokenProcessingException;
import org.fao.fi.security.common.support.token.impl.AbstractTokenProcessor;
import org.fao.fi.security.common.utilities.EncryptionUtils;

public class PGPEncryptedTokenProcessor
extends AbstractTokenProcessor {
    private PGPDecryptorBean _pgpDecryptor;
    private PGPEncryptorBean _pgpEncryptor;

    @Inject
    public PGPEncryptedTokenProcessor(PGPDecryptorBean pgpDecryptor, PGPEncryptorBean pgpEncryptor) {
        this._pgpDecryptor = pgpDecryptor;
        this._pgpEncryptor = pgpEncryptor;
    }

    @Override
    public String processAfterCreation(String token) throws TokenProcessingException {
        try {
            return token == null ? null : new String(EncryptionUtils.toBase64(this._pgpEncryptor.encryptBytes(token.getBytes("UTF-8"))));
        }
        catch (KeyringAccessException KAe) {
            this._log.error("Processing token after creation yield a keyring access error: {}", (Object)KAe.getMessage(), (Object)KAe);
            throw new TokenProcessingException("Token can't be processed due to encryption / decryption problems (see log for further details)");
        }
        catch (MissingOrBadKeyringException MOBKe) {
            this._log.error("Processing token after creation yield a bad keyring error: {}", (Object)MOBKe.getMessage(), (Object)MOBKe);
            throw new TokenProcessingException("Token can't be processed due to keyring problems (see log for further details)");
        }
        catch (Throwable t) {
            this._log.error("Processing token after creation yield an error: {}", (Object)t.getMessage(), (Object)t);
            throw new TokenProcessingException("Token can't be processed correctly after creation");
        }
    }

    @Override
    public String processBeforeConsumption(String token) throws TokenProcessingException {
        try {
            return token == null ? null : new String(this._pgpDecryptor.decryptBytes(EncryptionUtils.fromBase64(token)), "UTF-8");
        }
        catch (Throwable t) {
            this._log.error("Processing token before consumption yield an error: {}", (Object)t.getMessage(), (Object)t);
            throw new TokenProcessingException("Token can't be processed correctly before consumption");
        }
    }
}

