/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.common.utilities;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.util.encoders.Base64Encoder;

public final class EncryptionUtils {
    private static Base64Encoder BASE_64_ENCODER = new Base64Encoder();

    private EncryptionUtils() {
    }

    public static String getMD5Sum(String content) throws NoSuchAlgorithmException {
        return EncryptionUtils.getMD5Sum(content.getBytes());
    }

    public static String getMD5Sum(byte[] content) throws NoSuchAlgorithmException {
        MessageDigest complete = MessageDigest.getInstance("MD5");
        complete.update(content);
        return EncryptionUtils.convertToHexString(complete.digest());
    }

    public static String getMD5Sum(File file) throws NoSuchAlgorithmException, IOException {
        return EncryptionUtils.getMD5Sum(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5Sum(InputStream stream) throws NoSuchAlgorithmException, IOException {
        MessageDigest complete = MessageDigest.getInstance("MD5");
        try {
            new DigestInputStream(stream, complete);
        }
        finally {
            stream.close();
        }
        return EncryptionUtils.convertToHexString(complete.digest());
    }

    private static String convertToHexString(byte[] toConvert) {
        assert (toConvert.length == 16) : "Result length (in bytes) should be 16 instead of " + toConvert.length;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < toConvert.length; ++i) {
            result.append(Integer.toString((toConvert[i] & 0xFF) + 256, 16).substring(1));
        }
        assert (result.length() == 32) : "Converted result length should be 32 instead of " + result.length();
        return result.toString();
    }

    public static String base64PrettyPrint(byte[] bytes) throws IOException {
        return EncryptionUtils.base64PrettyPrint(EncryptionUtils.toBase64(bytes));
    }

    public static String base64PrettyPrint(String base64) throws IOException {
        StringBuilder result = new StringBuilder();
        int counter = 0;
        for (char in : base64.toCharArray()) {
            result.append(in);
            if (++counter % 76 != 0) continue;
            result.append("\n");
        }
        return result.toString();
    }

    public static byte[] fromBase64(String string) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BASE_64_ENCODER.decode(string, (OutputStream)baos);
        baos.flush();
        baos.close();
        return baos.toByteArray();
    }

    public static String toBase64(byte[] bytes) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BASE_64_ENCODER.encode(bytes, 0, bytes.length, (OutputStream)baos);
        baos.flush();
        baos.close();
        return new String(baos.toByteArray());
    }
}

