/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.common.utilities.pgp;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Date;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyPair;

public final class RSAKeyGen {
    public static void main(String[] args) throws IOException, PGPException {
        System.out.println("### " + RSAKeyGen.class.getName());
        if (args == null || args.length != 4) {
            System.err.println("Usage: " + RSAKeyGen.class.getSimpleName() + " <user id> <passphrase> <public keyring output file> <private keyring output file>");
            System.exit(-1);
        }
        File publicKR = new File(args[2]);
        File privateKR = new File(args[3]);
        new RSAKeyGen().generateKeys(args[0], args[1], publicKR, privateKR);
        System.out.println("Public / private keyrings have been written at:");
        System.out.println(" # " + publicKR.getAbsolutePath());
        System.out.println(" # " + privateKR.getAbsolutePath());
        System.out.println("respectively");
    }

    public void generateKeys(String userId, String passphrase, File publicKeyringFile, File privateKeyringFile) throws IOException, PGPException {
        PGPKeyRingGenerator keyringGenerator = this.generateKeyRingGenerator(userId, passphrase.toCharArray());
        FileOutputStream publicKeyringFileOutputStream = new FileOutputStream(publicKeyringFile);
        FileOutputStream privateKeyringFileOutputStream = new FileOutputStream(privateKeyringFile);
        PGPPublicKeyRing publicKeyring = keyringGenerator.generatePublicKeyRing();
        PGPSecretKeyRing secretKeyring = keyringGenerator.generateSecretKeyRing();
        BufferedOutputStream publicKeyringOutputStream = new BufferedOutputStream(publicKeyringFileOutputStream);
        publicKeyring.encode((OutputStream)publicKeyringOutputStream);
        publicKeyringOutputStream.flush();
        publicKeyringOutputStream.close();
        publicKeyringFileOutputStream.flush();
        publicKeyringFileOutputStream.close();
        BufferedOutputStream privateKeyringOutputStream = new BufferedOutputStream(privateKeyringFileOutputStream);
        secretKeyring.encode((OutputStream)privateKeyringOutputStream);
        privateKeyringOutputStream.flush();
        privateKeyringOutputStream.close();
        privateKeyringFileOutputStream.flush();
        privateKeyringFileOutputStream.close();
    }

    private PGPKeyRingGenerator generateKeyRingGenerator(String id, char[] pass) throws PGPException {
        return this.generateKeyRingGenerator(id, pass, 192);
    }

    private PGPKeyRingGenerator generateKeyRingGenerator(String id, char[] pass, int s2kcount) throws PGPException {
        RSAKeyPairGenerator kpg = new RSAKeyPairGenerator();
        kpg.init((KeyGenerationParameters)new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), new SecureRandom(), 2048, 12));
        BcPGPKeyPair rsakp_sign = new BcPGPKeyPair(3, kpg.generateKeyPair(), new Date());
        BcPGPKeyPair rsakp_enc = new BcPGPKeyPair(2, kpg.generateKeyPair(), new Date());
        PGPSignatureSubpacketGenerator signhashgen = new PGPSignatureSubpacketGenerator();
        signhashgen.setKeyFlags(false, 3);
        signhashgen.setPreferredSymmetricAlgorithms(false, new int[]{9, 8, 7});
        signhashgen.setPreferredHashAlgorithms(false, new int[]{8, 2, 9, 10, 11});
        signhashgen.setFeature(false, (byte)1);
        PGPSignatureSubpacketGenerator enchashgen = new PGPSignatureSubpacketGenerator();
        enchashgen.setKeyFlags(false, 12);
        PGPDigestCalculator sha1Calc = new BcPGPDigestCalculatorProvider().get(2);
        PGPDigestCalculator sha256Calc = new BcPGPDigestCalculatorProvider().get(8);
        PBESecretKeyEncryptor pske = new BcPBESecretKeyEncryptorBuilder(9, sha256Calc, s2kcount).build(pass);
        PGPKeyRingGenerator keyRingGen = new PGPKeyRingGenerator(19, (PGPKeyPair)rsakp_sign, id, sha1Calc, signhashgen.generate(), null, (PGPContentSignerBuilder)new BcPGPContentSignerBuilder(rsakp_sign.getPublicKey().getAlgorithm(), 2), pske);
        keyRingGen.addSubKey((PGPKeyPair)rsakp_enc, enchashgen.generate(), null);
        return keyRingGen;
    }
}

