/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.common.utilities.pgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Iterator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.fao.fi.security.common.encryption.pgp.exceptions.KeyringAccessException;
import org.fao.fi.security.common.encryption.pgp.exceptions.KeyringException;
import org.fao.fi.security.common.utilities.FileUtils;
import org.fao.fi.security.common.utilities.pgp.AbstractPGPProcessor;

public class PGPEncryptor
extends AbstractPGPProcessor {
    public byte[] encryptBytes(byte[] toEncrypt, File publicKeyFile) throws IOException, KeyringException, PGPException, NoSuchProviderException {
        return this.encryptBytes(toEncrypt, new FileInputStream(publicKeyFile));
    }

    public byte[] encryptBytes(byte[] toEncrypt, InputStream publicKeyStream) throws IOException, KeyringException, PGPException, NoSuchProviderException {
        return this.encryptBytes(toEncrypt, this.readPublicKeyFromKeyringCollection(publicKeyStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encryptBytes(byte[] toEncrypt, PGPPublicKey publicKey) throws IOException, PGPException, NoSuchProviderException {
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        try (ByteArrayInputStream byteInStream = new ByteArrayInputStream(toEncrypt);){
            this.encryptStream((InputStream)byteInStream, (OutputStream)byteOutStream, publicKey);
            byteOutStream.flush();
            byteOutStream.close();
            byte[] byArray = byteOutStream.toByteArray();
            return byArray;
        }
    }

    public void encryptStream(InputStream toEncrypt, OutputStream encrypted, File publicKeyFile) throws IOException, KeyringException, PGPException, NoSuchProviderException {
        this.encryptStream(toEncrypt, encrypted, new FileInputStream(publicKeyFile));
    }

    public void encryptStream(InputStream toEncrypt, OutputStream encrypted, InputStream publicKeyStream) throws IOException, KeyringException, PGPException, NoSuchProviderException {
        this.encryptStream(toEncrypt, encrypted, this.readPublicKeyFromKeyringCollection(publicKeyStream));
    }

    public void encryptStream(InputStream toEncrypt, OutputStream encrypted, PGPPublicKey publicKey) throws IOException, PGPException, NoSuchProviderException {
        this._log.debug(" * Key Strength   = {}", (Object)publicKey.getBitStrength());
        this._log.debug(" * Algorithm      = {}", (Object)publicKey.getAlgorithm());
        this._log.debug(" * Bit strength   = {}", (Object)publicKey.getBitStrength());
        this._log.debug(" * Version        = {}", (Object)publicKey.getVersion());
        this._log.debug(" * Encryption key = {}", (Object)publicKey.isEncryptionKey());
        this._log.debug(" * Master key     = {}", (Object)publicKey.isMasterKey());
        int numKeys = 0;
        Iterator userIDs = publicKey.getUserIDs();
        while (userIDs.hasNext()) {
            this._log.debug(" * User ID        = {}", userIDs.next());
            ++numKeys;
        }
        this._log.debug(" * Key Count      = {}", (Object)numKeys);
        this.doEncryptStream(toEncrypt, encrypted, publicKey);
    }

    public PGPPublicKey readPublicKeyFromKeyringCollection(File publicKeyFile) throws IOException, KeyringAccessException, PGPException {
        return this.readPublicKeyFromKeyringCollection(new FileInputStream(publicKeyFile));
    }

    public PGPPublicKey readPublicKeyFromKeyringCollection(InputStream publicKeyStream) throws IOException, KeyringAccessException, PGPException {
        try {
            PGPPublicKeyRing publicKeyRing = null;
            PGPPublicKeyRingCollection publicKeyRingCollection = new PGPPublicKeyRingCollection(publicKeyStream);
            this._log.debug(" * Key ring size = {}", (Object)publicKeyRingCollection.size());
            Iterator keyRingIterator = publicKeyRingCollection.getKeyRings();
            while (keyRingIterator.hasNext()) {
                publicKeyRing = (PGPPublicKeyRing)keyRingIterator.next();
                Iterator publicKeysIterator = publicKeyRing.getPublicKeys();
                while (publicKeysIterator.hasNext()) {
                    PGPPublicKey publicKey = (PGPPublicKey)publicKeysIterator.next();
                    if (!publicKey.isEncryptionKey()) continue;
                    PGPPublicKey pGPPublicKey = publicKey;
                    return pGPPublicKey;
                }
            }
            throw new KeyringAccessException("Unable to extract public key from keyring");
        }
        finally {
            if (publicKeyStream != null) {
                publicKeyStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doEncryptStream(InputStream toEncrypt, OutputStream encryptedStream, PGPPublicKey publicKey) throws IOException, PGPException, NoSuchProviderException {
        File tempFile = File.createTempFile("plain", "tpgp");
        FileOutputStream tempFileStream = new FileOutputStream(tempFile);
        try {
            tempFile.deleteOnExit();
            FileUtils.pipeStreams(toEncrypt, tempFileStream);
            tempFileStream.flush();
            encryptedStream = new DataOutputStream(encryptedStream);
            ByteArrayOutputStream targetOutputStream = new ByteArrayOutputStream();
            PGPCompressedDataGenerator compressedDataGenerator = new PGPCompressedDataGenerator(1);
            PGPUtil.writeFileToLiteralData((OutputStream)compressedDataGenerator.open((OutputStream)targetOutputStream), (char)'b', (File)tempFile);
            compressedDataGenerator.close();
            BouncyCastleProvider provider = new BouncyCastleProvider();
            SecureRandom random = new SecureRandom();
            PGPEncryptedDataGenerator encryptor = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)new JcePGPDataEncryptorBuilder(3).setSecureRandom(random).setProvider((Provider)provider));
            encryptor.addMethod((PGPKeyEncryptionMethodGenerator)new JcePublicKeyKeyEncryptionMethodGenerator(publicKey).setProvider((Provider)provider).setSecureRandom(random));
            byte[] bytes = targetOutputStream.toByteArray();
            OutputStream wrappedOutputStream = encryptor.open(encryptedStream, (long)bytes.length);
            wrappedOutputStream.write(bytes);
            encryptor.close();
            encryptedStream.close();
            long l = tempFile.length();
            return l;
        }
        finally {
            ((OutputStream)tempFileStream).close();
            tempFile.delete();
        }
    }
}

