/**
 * (c) 2014 FAO / UN (project: fi-security-server)
 */
package org.fao.fi.security.server.providers.validators.token.impl.configuration;

import javax.enterprise.inject.Alternative;
import javax.naming.NamingException;

import org.fao.fi.security.common.support.configuration.AbstractJNDIConfiguration;
import org.fao.fi.security.server.providers.validators.token.spi.TokenManagerConfigurator;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 3 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 3 May 2014
 */
@Alternative
public class TokenManagerJNDIConfiguration extends AbstractJNDIConfiguration implements TokenManagerConfigurator {
	private String _tokenCacheIdResource;
	private String _tokenCacheSizeResource;
	private String _tokenExpirationTimeResource;
	
	/**
	 * Class constructor
	 */
	public TokenManagerJNDIConfiguration() throws NamingException {
		this("token/manager/cache/id", 
			 "token/manager/cache/size",
			 "token/manager/expiration/time");
	}
	
	/**
	 * Class constructor
	 *
	 * @param tokenCacheIdResource
	 * @param tokenCacheSizeResource
	 * @param tokenExpirationTimeResource
	 */
	public TokenManagerJNDIConfiguration(String tokenCacheIdResource, String tokenCacheSizeResource, String tokenExpirationTimeResource) throws NamingException {
		super();
		this._tokenCacheIdResource = tokenCacheIdResource;
		this._tokenCacheSizeResource = tokenCacheSizeResource;
		this._tokenExpirationTimeResource = tokenExpirationTimeResource;
	}
	
	/**
	 * @return the 'tokenCacheIdResource' value
	 */
	public String getTokenCacheIdResource() {
		return this._tokenCacheIdResource;
	}

	/**
	 * @param tokenCacheIdResource the 'tokenCacheIdResource' value to set
	 */
	public void setTokenCacheIdResource(String tokenCacheIdResource) {
		this._tokenCacheIdResource = tokenCacheIdResource;
	}

	/**
	 * @return the 'tokenCacheSizeResource' value
	 */
	public String getTokenCacheSizeResource() {
		return this._tokenCacheSizeResource;
	}

	/**
	 * @param tokenCacheSizeResource the 'tokenCacheSizeResource' value to set
	 */
	public void setTokenCacheSizeResource(String tokenCacheSizeResource) {
		this._tokenCacheSizeResource = tokenCacheSizeResource;
	}

	/**
	 * @return the 'tokenExpirationTimeResource' value
	 */
	public String getTokenExpirationTimeResource() {
		return this._tokenExpirationTimeResource;
	}

	/**
	 * @param tokenExpirationTimeResource the 'tokenExpirationTimeResource' value to set
	 */
	public void setTokenExpirationTimeResource(String tokenExpirationTimeResource) {
		this._tokenExpirationTimeResource = tokenExpirationTimeResource;
	}

	/* (non-Javadoc)
	 * @see org.fao.fi.security.server.providers.validators.token.spi.TokenManagerConfiguration#getTokenCacheId()
	 */
	@Override
	public String getTokenCacheId() {
		return this.getEnvResource(this._tokenCacheIdResource);
	}

	/* (non-Javadoc)
	 * @see org.fao.fi.security.server.providers.validators.token.spi.TokenManagerConfiguration#getTokenCacheSize()
	 */
	@Override
	public int getTokenCacheSize() {
		return this.getEnvResource(this._tokenCacheIdResource);
	}

	/* (non-Javadoc)
	 * @see org.fao.fi.security.server.providers.validators.token.spi.TokenManagerConfiguration#getTokenExpirationTime()
	 */
	@Override
	public int getTokenExpirationTime() {
		return this.getEnvResource(this._tokenExpirationTimeResource);
	}
}
