/**
 * (c) 2014 FAO / UN (project: fi-security-server)
 */
package org.fao.fi.security.server.providers.validators.token.spi;

import javax.ws.rs.container.ContainerRequestContext;

import org.fao.fi.security.common.services.exceptions.UnauthorizedRequestException;
import org.fao.fi.security.common.services.exceptions.token.InvalidTokenException;
import org.fao.fi.security.common.services.exceptions.token.MissingTokenException;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 29 Apr 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 29 Apr 2014
 */
public interface TokenConsumer {
	boolean isTokenValid(String token) throws InvalidTokenException;
	
	void consumeTokenIfValid(String token) throws InvalidTokenException, UnauthorizedRequestException;
	
	String extractToken(ContainerRequestContext request) throws MissingTokenException;

	String process(String token) throws Throwable;
}