/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.oak.management.ManagementOperation;
import org.apache.jackrabbit.oak.plugins.blob.BlobGCMBean;
import org.apache.jackrabbit.oak.plugins.blob.BlobGarbageCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobGC
implements BlobGCMBean {
    private static final Logger log = LoggerFactory.getLogger(BlobGC.class);
    public static final String OP_NAME = "Blob garbage collection";
    private final BlobGarbageCollector blobGarbageCollector;
    private final Executor executor;
    private ManagementOperation gcOp = ManagementOperation.done("Blob garbage collection", 0L);

    public BlobGC(@Nonnull BlobGarbageCollector blobGarbageCollector, @Nonnull Executor executor) {
        this.blobGarbageCollector = Preconditions.checkNotNull(blobGarbageCollector);
        this.executor = Preconditions.checkNotNull(executor);
    }

    @Override
    @Nonnull
    public CompositeData startBlobGC() {
        if (this.gcOp.isDone()) {
            this.gcOp = new ManagementOperation(OP_NAME, new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    long t0 = System.nanoTime();
                    BlobGC.this.blobGarbageCollector.collectGarbage();
                    return System.nanoTime() - t0;
                }
            });
            this.executor.execute(this.gcOp);
        }
        return this.getBlobGCStatus();
    }

    @Override
    @Nonnull
    public CompositeData getBlobGCStatus() {
        return this.gcOp.getStatus().toCompositeData();
    }
}

