/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.index;

import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Cursors;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class TraversingIndex
implements QueryIndex {
    @Override
    public Cursor query(Filter filter, NodeState rootState) {
        return Cursors.newTraversingCursor(filter, rootState);
    }

    @Override
    public double getCost(Filter filter, NodeState rootState) {
        if (filter.getFullTextConstraint() != null) {
            return Double.POSITIVE_INFINITY;
        }
        if (filter.containsNativeConstraint()) {
            return Double.POSITIVE_INFINITY;
        }
        if (filter.isAlwaysFalse()) {
            return 0.0;
        }
        double nodeCount = 1.0E7;
        String path = filter.getPath();
        Filter.PathRestriction restriction = filter.getPathRestriction();
        switch (restriction) {
            case NO_RESTRICTION: {
                break;
            }
            case EXACT: {
                nodeCount = 1.0;
                break;
            }
            case ALL_CHILDREN: {
                if (PathUtils.denotesRoot(path)) break;
                for (int depth = PathUtils.getDepth(path); depth > 0; --depth) {
                    nodeCount /= 10.0;
                }
                break;
            }
            case PARENT: {
                if (PathUtils.denotesRoot(path)) {
                    nodeCount = 1.0;
                    break;
                }
                nodeCount = PathUtils.getDepth(path);
                break;
            }
            case DIRECT_CHILDREN: {
                nodeCount = 1000000.0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown restriction: " + (Object)((Object)restriction));
            }
        }
        return nodeCount;
    }

    @Override
    public String getPlan(Filter filter, NodeState rootState) {
        return "traverse \"" + filter.getPathPlan() + '\"';
    }

    @Override
    public String getIndexName() {
        return "traverse";
    }
}

