/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.namepath.PathMapper;
import org.apache.jackrabbit.oak.security.user.AuthorizableImpl;
import org.apache.jackrabbit.oak.security.user.AuthorizableIterator;
import org.apache.jackrabbit.oak.security.user.MembershipProvider;
import org.apache.jackrabbit.oak.security.user.TreeBasedPrincipal;
import org.apache.jackrabbit.oak.security.user.UserManagerImpl;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GroupImpl
extends AuthorizableImpl
implements org.apache.jackrabbit.api.security.user.Group {
    private static final Logger log = LoggerFactory.getLogger(GroupImpl.class);

    GroupImpl(String id, Tree tree, UserManagerImpl userManager) throws RepositoryException {
        super(id, tree, userManager);
    }

    @Override
    void checkValidTree(Tree tree) throws RepositoryException {
        if (tree == null || !UserUtil.isType(tree, AuthorizableType.GROUP)) {
            throw new IllegalArgumentException("Invalid group node: node type rep:Group expected.");
        }
    }

    @Override
    public boolean isGroup() {
        return true;
    }

    @Override
    public Principal getPrincipal() throws RepositoryException {
        return new GroupPrincipal(this.getPrincipalName(), this.getTree());
    }

    @Override
    public Iterator<Authorizable> getDeclaredMembers() throws RepositoryException {
        return this.getMembers(false);
    }

    @Override
    public Iterator<Authorizable> getMembers() throws RepositoryException {
        return this.getMembers(true);
    }

    @Override
    public boolean isDeclaredMember(Authorizable authorizable) throws RepositoryException {
        return this.isMember(authorizable, false);
    }

    @Override
    public boolean isMember(Authorizable authorizable) throws RepositoryException {
        return this.isMember(authorizable, true);
    }

    @Override
    public boolean addMember(Authorizable authorizable) throws RepositoryException {
        if (!GroupImpl.isValidAuthorizableImpl(authorizable)) {
            log.warn("Invalid Authorizable: {}", (Object)authorizable);
            return false;
        }
        AuthorizableImpl authorizableImpl = (AuthorizableImpl)authorizable;
        if (this.isEveryone() || authorizableImpl.isEveryone()) {
            return false;
        }
        String memberID = authorizable.getID();
        if (authorizableImpl.isGroup()) {
            if (this.getID().equals(memberID)) {
                String msg = "Attempt to add a group as member of itself (" + this.getID() + ").";
                log.debug(msg);
                return false;
            }
            if (this.isCyclicMembership(authorizableImpl)) {
                log.warn("Attempt to create circular group membership.");
                return false;
            }
        }
        if (this.isDeclaredMember(authorizable)) {
            log.debug("Authorizable {} is already declared member of {}", (Object)memberID, (Object)this.getID());
            return false;
        }
        return this.getMembershipProvider().addMember(this.getTree(), authorizableImpl.getTree());
    }

    private boolean isCyclicMembership(AuthorizableImpl newMember) {
        if (newMember.isGroup()) {
            MembershipProvider mProvider = this.getMembershipProvider();
            String contentId = mProvider.getContentID(this.getTree());
            if (mProvider.isMember(newMember.getTree(), contentId, true)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeMember(Authorizable authorizable) throws RepositoryException {
        if (!GroupImpl.isValidAuthorizableImpl(authorizable)) {
            log.warn("Invalid Authorizable: {}", (Object)authorizable);
            return false;
        }
        if (this.isEveryone()) {
            return false;
        }
        Tree memberTree = ((AuthorizableImpl)authorizable).getTree();
        return this.getMembershipProvider().removeMember(this.getTree(), memberTree);
    }

    private Iterator<Authorizable> getMembers(boolean includeInherited) throws RepositoryException {
        UserManagerImpl userMgr = this.getUserManager();
        if (this.isEveryone()) {
            String propName = this.getUserManager().getNamePathMapper().getJcrName("rep:principalName");
            return Iterators.filter(userMgr.findAuthorizables(propName, null, 3), new Predicate<Authorizable>(){

                @Override
                public boolean apply(@Nullable Authorizable authorizable) {
                    if (authorizable == null) {
                        return false;
                    }
                    if (authorizable.isGroup()) {
                        try {
                            return !((GroupImpl)authorizable).isEveryone();
                        }
                        catch (RepositoryException e) {
                            log.warn("Unable to evaluate if authorizable is the 'everyone' group.", (Throwable)e);
                        }
                    }
                    return true;
                }
            });
        }
        Iterator<String> oakPaths = this.getMembershipProvider().getMembers(this.getTree(), AuthorizableType.AUTHORIZABLE, includeInherited);
        if (oakPaths.hasNext()) {
            AuthorizableIterator iterator = AuthorizableIterator.create(oakPaths, userMgr, AuthorizableType.AUTHORIZABLE);
            return new RangeIteratorAdapter(iterator, iterator.getSize());
        }
        return RangeIteratorAdapter.EMPTY;
    }

    private boolean isMember(Authorizable authorizable, boolean includeInherited) throws RepositoryException {
        if (!GroupImpl.isValidAuthorizableImpl(authorizable)) {
            return false;
        }
        if (this.getID().equals(authorizable.getID())) {
            return false;
        }
        if (this.isEveryone()) {
            return true;
        }
        Tree authorizableTree = ((AuthorizableImpl)authorizable).getTree();
        MembershipProvider mgr = this.getUserManager().getMembershipProvider();
        return mgr.isMember(this.getTree(), authorizableTree, includeInherited);
    }

    private class GroupPrincipal
    extends TreeBasedPrincipal
    implements Group {
        GroupPrincipal(String principalName, Tree groupTree) {
            super(principalName, groupTree, (PathMapper)GroupImpl.this.getUserManager().getNamePathMapper());
        }

        public boolean addMember(Principal principal) {
            throw new UnsupportedOperationException();
        }

        public boolean removeMember(Principal principal) {
            throw new UnsupportedOperationException();
        }

        public boolean isMember(Principal principal) {
            boolean isMember = false;
            try {
                if (GroupImpl.this.isEveryone()) {
                    isMember = !"everyone".equals(principal.getName());
                } else {
                    Authorizable a = GroupImpl.this.getUserManager().getAuthorizable(principal);
                    if (a != null) {
                        isMember = GroupImpl.this.isMember(a);
                    }
                }
            }
            catch (RepositoryException e) {
                log.warn("Failed to determine group membership", (Object)e.getMessage());
            }
            return isMember;
        }

        public Enumeration<? extends Principal> members() {
            Iterator<Authorizable> members;
            try {
                members = GroupImpl.this.getMembers();
            }
            catch (RepositoryException e) {
                String msg = "Unable to retrieve Group members: " + e.getMessage();
                log.error(msg);
                throw new IllegalStateException(msg);
            }
            Iterator<Principal> principals = Iterators.transform(members, new Function<Authorizable, Principal>(){

                @Override
                public Principal apply(Authorizable authorizable) {
                    if (authorizable == null) {
                        return null;
                    }
                    try {
                        return authorizable.getPrincipal();
                    }
                    catch (RepositoryException e) {
                        String msg = "Internal error while retrieving principal: " + e.getMessage();
                        log.error(msg);
                        throw new IllegalStateException(msg);
                    }
                }
            });
            return Iterators.asEnumeration(Iterators.filter(principals, Predicates.notNull()));
        }
    }
}

